/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SqmQuerySpecTranslation;
import org.hibernate.query.sqm.sql.SqmSelectTranslation;
import org.hibernate.query.sqm.sql.SqmSelectTranslator;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiation;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class StandardSqmSelectTranslator
extends BaseSqmToSqlAstConverter
implements SqmSelectTranslator {
    private final List<DomainResult> domainResults = CollectionHelper.arrayList(10);
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private Map<String, FilterPredicate> collectionFilterPredicates;
    private final Stack<OrderByFragmentConsumer> orderByFragmentConsumerStack = new StandardStack<OrderByFragmentConsumer>();

    public StandardSqmSelectTranslator(QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers fetchInfluencers, SqlAstCreationContext creationContext) {
        super(creationContext, queryOptions, fetchInfluencers, domainParameterXref, domainParameterBindings);
        AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        this.entityGraphTraversalState = appliedGraph != null && appliedGraph.getSemantic() != null && appliedGraph.getGraph() != null ? new StandardEntityGraphTraversalStateImpl(appliedGraph.getSemantic(), appliedGraph.getGraph()) : null;
    }

    @Override
    public SqmSelectTranslation translate(SqmSelectStatement sqmStatement) {
        return new SqmSelectTranslation(this.visitSelectStatement(sqmStatement), this.getJdbcParamsBySqmParam());
    }

    @Override
    public SqmQuerySpecTranslation translate(SqmQuerySpec querySpec) {
        return new SqmQuerySpecTranslation(this.visitQuerySpec(querySpec), this.getJdbcParamsBySqmParam());
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        QuerySpec querySpec = this.visitQuerySpec((SqmQuerySpec)statement.getQuerySpec());
        return new SelectStatement(querySpec, this.domainResults);
    }

    @Override
    protected void prepareQuerySpec(QuerySpec sqlQuerySpec) {
        boolean topLevel = this.orderByFragmentConsumerStack.isEmpty();
        if (topLevel) {
            this.orderByFragmentConsumerStack.push(new StandardOrderByFragmentConsumer());
        } else {
            this.orderByFragmentConsumerStack.push(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcessQuerySpec(QuerySpec sqlQuerySpec) {
        List<TableGroup> roots = sqlQuerySpec.getFromClause().getRoots();
        if (roots != null && roots.size() == 1) {
            TableGroup root = roots.get(0);
            ModelPartContainer modelPartContainer = root.getModelPart();
            EntityPersister entityPersister = modelPartContainer.findContainingEntityMapping().getEntityPersister();
            assert (entityPersister instanceof Joinable);
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityPersister), root);
            if (filterPredicate != null) {
                sqlQuerySpec.applyPredicate(filterPredicate);
            }
            if (CollectionHelper.isNotEmpty(this.collectionFilterPredicates)) {
                root.getTableGroupJoins().forEach(tableGroupJoin -> this.collectionFilterPredicates.forEach((alias, predicate) -> {
                    if (tableGroupJoin.getJoinedGroup().getGroupAlias().equals(alias)) {
                        tableGroupJoin.applyPredicate((Predicate)predicate);
                    }
                }));
            }
        }
        try {
            OrderByFragmentConsumer orderByFragmentConsumer = this.orderByFragmentConsumerStack.getCurrent();
            if (orderByFragmentConsumer != null) {
                orderByFragmentConsumer.visitFragments((orderByFragment, tableGroup) -> orderByFragment.apply(sqlQuerySpec, (TableGroup)tableGroup, this));
            }
        }
        finally {
            this.orderByFragmentConsumerStack.pop();
        }
    }

    @Override
    public Void visitSelection(SqmSelection sqmSelection) {
        DomainResultProducer resultProducer = this.resolveDomainResultProducer(sqmSelection);
        if (this.getProcessingStateStack().depth() > 1) {
            resultProducer.applySqlSelections(this);
        } else {
            DomainResult domainResult = resultProducer.createDomainResult(sqmSelection.getAlias(), this);
            this.domainResults.add(domainResult);
        }
        return null;
    }

    private DomainResultProducer resolveDomainResultProducer(SqmSelection sqmSelection) {
        return (DomainResultProducer)sqmSelection.getSelectableNode().accept(this);
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.getFromClauseIndex().findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        ArrayList<Fetch> fetches = CollectionHelper.arrayList(fetchParent.getReferencedMappingType().getNumberOfFetchables());
        ArrayList bagRoles = new ArrayList();
        BiConsumer<Fetchable, Boolean> fetchableBiConsumer = (fetchable, isKeyFetchable) -> {
            NavigablePath fetchablePath = fetchParent.getNavigablePath().append(fetchable.getFetchableName());
            Fetch biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, this);
            if (biDirectionalFetch != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            try {
                ++this.fetchDepth;
                Fetch fetch = this.buildFetch(fetchablePath, fetchParent, (Fetchable)fetchable, (boolean)isKeyFetchable);
                if (fetch != null) {
                    PluralAttributeMapping pluralAttributeMapping;
                    CollectionClassification collectionClassification;
                    if (fetch.getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof PluralAttributeMapping && (collectionClassification = (pluralAttributeMapping = (PluralAttributeMapping)fetchable).getMappedTypeDescriptor().getCollectionSemantics().getCollectionClassification()) == CollectionClassification.BAG) {
                        bagRoles.add(fetchable.getNavigableRole().getNavigableName());
                    }
                    fetches.add(fetch);
                }
            }
            finally {
                --this.fetchDepth;
            }
        };
        fetchParent.getReferencedMappingContainer().visitKeyFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, true), null);
        fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, false), null);
        if (bagRoles.size() > 1) {
            throw new MultipleBagFetchException(bagRoles);
        }
        return fetches;
    }

    private Fetch buildFetch(NavigablePath fetchablePath, FetchParent fetchParent, Fetchable fetchable, boolean isKeyFetchable) {
        String alias;
        LockMode lockMode = LockMode.READ;
        FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
        boolean joined = false;
        EntityGraphTraversalState.TraversalResult traversalResult = null;
        SqmAttributeJoin fetchedJoin = this.getFromClauseIndex().findFetchedJoinByPath(fetchablePath);
        if (fetchedJoin != null) {
            assert (this.getFromClauseIndex().getTableGroup(fetchablePath) != null);
            if (fetchedJoin.isFetched()) {
                fetchTiming = FetchTiming.IMMEDIATE;
            }
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            lockMode = this.determineLockMode(alias);
        } else {
            Integer maxDepth;
            TableGroup existingJoinedGroup;
            alias = null;
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    fetchTiming = traversalResult.getFetchStrategy();
                    joined = traversalResult.isJoined();
                } else if (this.getLoadQueryInfluencers().hasEnabledFetchProfiles() && fetchParent instanceof EntityResultGraphNode) {
                    EntityResultGraphNode entityFetchParent = (EntityResultGraphNode)fetchParent;
                    EntityMappingType entityMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
                    String fetchParentEntityName = entityMappingType.getEntityName();
                    String fetchableRole = fetchParentEntityName + "." + fetchable.getFetchableName();
                    for (String enabledFetchProfileName : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
                        FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(enabledFetchProfileName);
                        org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                        fetchTiming = FetchTiming.IMMEDIATE;
                        joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                    }
                }
            }
            if ((existingJoinedGroup = this.getFromClauseIndex().findTableGroup(fetchablePath)) != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null) {
                if (this.fetchDepth == maxDepth) {
                    joined = false;
                } else if (this.fetchDepth > maxDepth) {
                    return null;
                }
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                this.getFromClauseIndex().resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = this.getFromClauseIndex().getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, SqlAstJoinType.LEFT, LockMode.NONE, this);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        try {
            Fetch fetch = fetchable.generateFetch(fetchParent, fetchablePath, fetchTiming, joined, lockMode, alias, this);
            if (fetchable instanceof PluralAttributeMapping && fetch.getTiming() == FetchTiming.IMMEDIATE && joined) {
                OrderByFragmentConsumer orderByFragmentConsumer;
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.getCreationContext().getSessionFactory());
                TableGroup tableGroup = this.getFromClauseAccess().getTableGroup(fetchablePath);
                FilterPredicate collectionFieldFilterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), joinable, tableGroup);
                if (collectionFieldFilterPredicate != null) {
                    if (this.collectionFilterPredicates == null) {
                        this.collectionFilterPredicates = new HashMap<String, FilterPredicate>();
                    }
                    this.collectionFilterPredicates.put(tableGroup.getGroupAlias(), collectionFieldFilterPredicate);
                }
                if (pluralAttributeMapping.getCollectionDescriptor().isManyToMany()) {
                    assert (joinable instanceof CollectionPersister);
                    FilterPredicate manyToManyFilterPredicate = FilterHelper.createManyToManyFilterPredicate(this.getLoadQueryInfluencers(), (CollectionPersister)((Object)joinable), tableGroup);
                    if (manyToManyFilterPredicate != null) {
                        assert (tableGroup.getTableReferenceJoins() != null && tableGroup.getTableReferenceJoins().size() == 1);
                        tableGroup.getTableReferenceJoins().get(0).applyPredicate(manyToManyFilterPredicate);
                    }
                }
                if ((orderByFragmentConsumer = this.orderByFragmentConsumerStack.getCurrent()) != null) {
                    assert (tableGroup.getModelPart() == pluralAttributeMapping);
                    if (pluralAttributeMapping.getOrderByFragment() != null) {
                        orderByFragmentConsumer.accept(pluralAttributeMapping.getOrderByFragment(), tableGroup);
                    }
                    if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
                        orderByFragmentConsumer.accept(pluralAttributeMapping.getManyToManyOrderByFragment(), tableGroup);
                    }
                }
            }
            Fetch fetch2 = fetch;
            return fetch2;
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
        finally {
            if (this.entityGraphTraversalState != null && traversalResult != null) {
                this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
            }
        }
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.getFromClauseIndex();
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        LockOptions lockOptions = this.getQueryOptions().getLockOptions();
        return lockOptions.getScope() || identificationVariable == null ? lockOptions.getLockMode() : lockOptions.getEffectiveLockMode(identificationVariable);
    }

    @Override
    public DynamicInstantiation visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaTypeDescriptor targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.getSelectableNode().accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <T> JavaTypeDescriptor<T> interpretInstantiationTarget(SqmDynamicInstantiationTarget instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType sqmExpression) {
        SqmExpressable nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitSqmPathEntityTypeExpression(SqmPathEntityType<?> sqmExpression) {
        return BasicValuedPathInterpretation.from(sqmExpression, this, this);
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        return this.visitCteStatement(sqmCte);
    }

    private static class StandardOrderByFragmentConsumer
    implements OrderByFragmentConsumer {
        private Map<OrderByFragment, TableGroup> fragments;

        private StandardOrderByFragmentConsumer() {
        }

        @Override
        public void accept(OrderByFragment orderByFragment, TableGroup tableGroup) {
            if (this.fragments == null) {
                this.fragments = new LinkedHashMap<OrderByFragment, TableGroup>();
            }
            this.fragments.put(orderByFragment, tableGroup);
        }

        @Override
        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> consumer) {
            if (this.fragments == null || this.fragments.isEmpty()) {
                return;
            }
            this.fragments.forEach(consumer);
        }
    }

    private static interface OrderByFragmentConsumer {
        public void accept(OrderByFragment var1, TableGroup var2);

        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> var1);
    }
}

