/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.internal.FilterHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SimpleSqmUpdateTranslation;
import org.hibernate.query.sqm.sql.SimpleSqmUpdateTranslator;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class StandardSqmUpdateTranslator
extends BaseSqmToSqlAstConverter
implements SimpleSqmUpdateTranslator {
    private static final SqlAliasBaseGenerator SQL_ALIAS_BASE_GENERATOR = new SqlAliasBaseGenerator(){
        private final SqlAliasBase sqlAliasBase = new SqlAliasBase(){

            @Override
            public String getAliasStem() {
                return null;
            }

            @Override
            public String generateNewAlias() {
                return null;
            }
        };

        @Override
        public SqlAliasBase createSqlAliasBase(String stem) {
            return this.sqlAliasBase;
        }
    };

    public StandardSqmUpdateTranslator(SqlAstCreationContext creationContext, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext, queryOptions, loadQueryInfluencers, domainParameterXref, domainParameterBindings);
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        return this.visitCteStatement(sqmCte);
    }

    @Override
    public SimpleSqmUpdateTranslation translate(SqmUpdateStatement sqmUpdate) {
        UpdateStatement sqlUpdateAst = this.visitUpdateStatement(sqmUpdate);
        return new SimpleSqmUpdateTranslation(sqlUpdateAst, this.getJdbcParamsBySqmParam());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatement visitUpdateStatement(SqmUpdateStatement sqmStatement) {
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, sqmStatement.getRoot().getAlias(), false, LockMode.WRITE, this.getSqlAliasBaseGenerator(), this.getSqlExpressionResolver(), () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            this.getFromClauseIndex().registerTableGroup(rootPath, rootTableGroup);
            Object assignments = this.visitSetClause(sqmStatement.getSetClause());
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityDescriptor));
            if (filterPredicate != null) {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = sqmStatement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            UpdateStatement updateStatement = new UpdateStatement(rootTableGroup.getPrimaryTableReference(), (List<Assignment>)assignments, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions));
            return updateStatement;
        }
        finally {
            this.getProcessingStateStack().pop();
        }
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return SQL_ALIAS_BASE_GENERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        for (SqmAssignment sqmAssignment : setClause.getAssignments()) {
            SqmPathInterpretation assignedPathInterpretation;
            final ArrayList targetColumnReferences = new ArrayList();
            this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(this.getProcessingStateStack().getCurrent(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    targetColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            });
            try {
                assignedPathInterpretation = (SqmPathInterpretation)sqmAssignment.getTargetPath().accept(this);
            }
            finally {
                this.getProcessingStateStack().pop();
            }
            this.inferableTypeAccessStack.push(assignedPathInterpretation::getExpressionType);
            final ArrayList valueColumnReferences = new ArrayList();
            this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(this.getProcessingStateStack().getCurrent(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    valueColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            });
            try {
                int assignedPathJdbcCount;
                if (sqmAssignment.getValue() instanceof SqmParameter) {
                    SqmParameter sqmParameter = (SqmParameter)sqmAssignment.getValue();
                    ArrayList jdbcParametersForSqm = new ArrayList();
                    assignedPathInterpretation.getExpressionType().visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
                        JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                        jdbcParametersForSqm.add(jdbcParameter);
                        assignments.add(new Assignment(new ColumnReference((String)null, columnExpression, isColumnExpressionFormula, jdbcMapping, this.getCreationContext().getSessionFactory()), jdbcParameter));
                    });
                    this.getJdbcParamsBySqmParam().put(sqmParameter, jdbcParametersForSqm);
                    continue;
                }
                MappingMetamodel domainModel = this.getCreationContext().getDomainModel();
                TypeConfiguration typeConfiguration = domainModel.getTypeConfiguration();
                Expression valueExpression = (Expression)sqmAssignment.getValue().accept(this);
                int valueExprJdbcCount = valueExpression.getExpressionType().getJdbcTypeCount(typeConfiguration);
                if (valueExprJdbcCount != (assignedPathJdbcCount = assignedPathInterpretation.getExpressionType().getJdbcTypeCount(typeConfiguration))) {
                    SqlTreeCreationLogger.LOGGER.debugf("JDBC type count does not match in UPDATE assignment between the assigned-path and the assigned-value; this will likely lead to problems executing the query", new Object[0]);
                }
                assert (assignedPathJdbcCount == valueExprJdbcCount);
                for (ColumnReference columnReference : targetColumnReferences) {
                    assignments.add(new Assignment(columnReference, valueExpression));
                }
            }
            finally {
                this.getProcessingStateStack().pop();
                this.inferableTypeAccessStack.pop();
            }
        }
        return assignments;
    }
}

