/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.IllegalPathUsageException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractSqmPath<T>
extends AbstractSqmExpression<T>
implements SqmPath<T> {
    private final NavigablePath navigablePath;
    private final SqmPath lhs;
    private Map<String, SqmPath> attributePathRegistry;
    private Map<String, SqmPath<?>> implicitJoinPaths;
    private SqmExpression pathTypeExpression;

    protected AbstractSqmPath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(referencedPathSource, nodeBuilder);
        this.navigablePath = navigablePath;
        this.lhs = lhs;
    }

    @Override
    public SqmPathSource<T> getNodeType() {
        return (SqmPathSource)super.getNodeType();
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return (SqmPathSource)super.getNodeType();
    }

    protected AbstractSqmPath(SqmPathSource<T> referencedPathSource, SqmPath lhs, NodeBuilder nodeBuilder) {
        this(lhs == null ? new NavigablePath(referencedPathSource.getPathName()) : lhs.getNavigablePath().append(referencedPathSource.getPathName()), referencedPathSource, lhs, nodeBuilder);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.lhs;
    }

    @Override
    public List<SqmPath<?>> getImplicitJoinPaths() {
        if (this.implicitJoinPaths == null) {
            return Collections.emptyList();
        }
        return new ArrayList(this.implicitJoinPaths.values());
    }

    @Override
    public void visitImplicitJoinPaths(Consumer<SqmPath<?>> consumer) {
        if (this.implicitJoinPaths != null) {
            this.implicitJoinPaths.values().forEach(consumer);
        }
    }

    @Override
    public void registerImplicitJoinPath(SqmPath<?> path) {
        String relativeName;
        SqmPath<?> previous;
        assert (path.getLhs() == this);
        if (this.implicitJoinPaths == null) {
            this.implicitJoinPaths = new HashMap();
        }
        if ((previous = this.implicitJoinPaths.put(relativeName = path.getNavigablePath().getLocalName(), path)) != null && previous != path) {
            log.debugf("Implicit-join path registration unexpectedly overrode previous registration - `%s`", (Object)relativeName);
        }
    }

    @Override
    public String getExplicitAlias() {
        return this.getAlias();
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.setAlias(explicitAlias);
    }

    public SqmPathSource<T> getModel() {
        return this.getReferencedPathSource();
    }

    public SqmExpression<Class<? extends T>> type() {
        if (this.pathTypeExpression == null) {
            String discriminatorPathName = "{type}";
            final NavigablePath discriminatorNavigablePath = this.getNavigablePath().append("{type}");
            DomainType<?> sqmNodeType = this.getReferencedPathSource().getSqmPathType();
            if (sqmNodeType instanceof EntityDomainType) {
                SqmPathSource discriminatorPathSource = new SqmPathSource(){

                    @Override
                    public String getPathName() {
                        return "{type}";
                    }

                    @Override
                    public DomainType<?> getSqmPathType() {
                        return null;
                    }

                    @Override
                    public SqmPathSource<?> findSubPathSource(String name) {
                        throw new IllegalPathUsageException("Entity discriminator cannot be de-referenced");
                    }

                    public SqmPath createSqmPath(SqmPath lhs, SqmCreationState creationState) {
                        return new SqmBasicValuedSimplePath(discriminatorNavigablePath, this, (SqmPath)AbstractSqmPath.this, AbstractSqmPath.this.nodeBuilder());
                    }

                    public Bindable.BindableType getBindableType() {
                        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
                    }

                    public Class getBindableJavaType() {
                        return null;
                    }

                    @Override
                    public JavaTypeDescriptor getExpressableJavaTypeDescriptor() {
                        return null;
                    }
                };
                this.pathTypeExpression = new SqmBasicValuedSimplePath(discriminatorNavigablePath, discriminatorPathSource, (SqmPath)this, this.nodeBuilder());
            } else {
                throw new UnsupportedOperationException("SqmPath [" + this.getClass().getName() + "] cannot be typed");
            }
        }
        return this.pathTypeExpression;
    }

    public SqmPath get(String attributeName) {
        return this.resolvePath(attributeName, (pathSource, name) -> {
            SqmPathSource<?> subNavigable = this.getReferencedPathSource().findSubPathSource(attributeName);
            if (subNavigable instanceof SingularPersistentAttribute) {
                return this.createSingularPath((SingularPersistentAttribute)subNavigable);
            }
            assert (subNavigable instanceof PluralPersistentAttribute);
            return this.createPluralPath((PluralPersistentAttribute)subNavigable);
        });
    }

    private SqmPath createSingularPath(SingularPersistentAttribute attribute) {
        NavigablePath subNavPath = this.getNavigablePath().append(attribute.getPathName());
        switch (attribute.getAttributeClassification()) {
            case BASIC: {
                return new SqmBasicValuedSimplePath(subNavPath, attribute, (SqmPath)this, this.nodeBuilder());
            }
            case EMBEDDED: {
                return new SqmEmbeddedValuedSimplePath(subNavPath, attribute, (SqmPath)this, this.nodeBuilder());
            }
            case ANY: {
                return new SqmAnyValuedSimplePath(subNavPath, attribute, (SqmPath)this, this.nodeBuilder());
            }
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                return new SqmEntityValuedSimplePath(subNavPath, attribute, (SqmPath)this, this.nodeBuilder());
            }
        }
        throw new UnsupportedOperationException(String.format(Locale.ROOT, "Cannot create SqmPath from singular attribute [%s#%s] - unknown classification : %s", new Object[]{attribute.getDeclaringType().getTypeName(), attribute.getName(), attribute.getAttributeClassification()}));
    }

    private SqmPath createPluralPath(PluralPersistentAttribute pluralAttribute) {
        return new SqmPluralValuedSimplePath(this.getNavigablePath().append(pluralAttribute.getPathName()), pluralAttribute, (SqmPath)this, this.nodeBuilder());
    }

    private SqmPath resolvePath(String attributeName, BiFunction<SqmPath, String, SqmPath> creator) {
        JpaPath pathSource = this.getLhs();
        if (this.attributePathRegistry == null) {
            this.attributePathRegistry = new HashMap<String, SqmPath>();
            SqmPath path = creator.apply((SqmPath)pathSource, attributeName);
            this.attributePathRegistry.put(attributeName, path);
            return path;
        }
        return this.attributePathRegistry.computeIfAbsent(attributeName, arg_0 -> AbstractSqmPath.lambda$resolvePath$1(creator, (SqmPath)pathSource, attributeName, arg_0));
    }

    public SqmPath get(SingularAttribute jpaAttribute) {
        SingularPersistentAttribute attribute = (SingularPersistentAttribute)jpaAttribute;
        return this.resolvePath(attribute.getName(), (pathSource, name) -> this.createSingularPath(attribute));
    }

    public SqmPath get(PluralAttribute attribute) {
        return this.resolvePath(attribute.getName(), (pathSource, name) -> this.createPluralPath((PluralPersistentAttribute)attribute));
    }

    public SqmPath get(MapAttribute map) {
        return this.resolvePath(map.getName(), (pathSource, name) -> this.createPluralPath((MapPersistentAttribute)map));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath.getFullPath() + ")";
    }

    private static /* synthetic */ SqmPath lambda$resolvePath$1(BiFunction creator, SqmPath pathSource, String attributeName, String name) {
        return (SqmPath)creator.apply(pathSource, attributeName);
    }
}

