/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPathWrapper;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmCorrelatedRoot<T>
extends SqmRoot<T>
implements SqmPathWrapper<T, T>,
SqmCorrelation<T, T> {
    private SqmRoot<T> correlationParent;

    public SqmCorrelatedRoot(SqmRoot<T> correlationParent, NodeBuilder nodeBuilder) {
        super(correlationParent.getReferencedPathSource(), correlationParent.getAlias(), nodeBuilder);
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmRoot<T> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.getCorrelationParent();
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmFrom<T, T> correlateTo(JpaSubQuery<T> subquery) {
        SqmSubQuery sqmSubQuery = (SqmSubQuery)subquery;
        SqmCorrelatedRoot<T> correlation = new SqmCorrelatedRoot<T>(this, this.nodeBuilder());
        ((SqmQuerySpec)sqmSubQuery.getQuerySpec()).getFromClause().addRoot(correlation);
        return correlation;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelation(this);
    }
}

