/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.PathException;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmAttributeJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmSingularJoin<O, T>
extends AbstractSqmAttributeJoin<O, T>
implements DomainResultProducer<T> {
    public SqmSingularJoin(SqmFrom<?, O> lhs, SingularPersistentAttribute<O, T> joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, joinedNavigable, alias, joinType, fetched, nodeBuilder);
    }

    public SingularPersistentAttribute<O, T> getReferencedPathSource() {
        return (SingularPersistentAttribute)super.getReferencedPathSource();
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.getNodeJavaTypeDescriptor();
    }

    public <S extends T> SqmTreatedSingularJoin<O, T, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends T> SqmTreatedSingularJoin<O, T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        return new SqmTreatedSingularJoin(this, treatTarget, null);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "SqmSingularJoin(%s : %s)", this.getNavigablePath().getFullPath(), this.getReferencedPathSource().getPathName());
    }

    @Override
    public SqmAttributeJoin makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmSingularJoin<O, T>(creationProcessingState.getPathRegistry().findFromByPath(this.getLhs().getNavigablePath()), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), this.nodeBuilder());
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, TypeConfiguration typeConfiguration) {
        SqmPathSource attribute = this.getReferencedPathSource();
        ManagedDomainType attributeType = (ManagedDomainType)attribute.getType();
        if (!(attributeType instanceof EntityDomainType)) {
            if (attributeType instanceof EmbeddableDomainType) {
                throw new NotYetImplementedFor6Exception(this.getClass());
            }
            throw new HibernateException("Unexpected declaring ");
        }
        EntityDomainType entityDomainType = (EntityDomainType)attributeType;
        String entityName = entityDomainType.getHibernateEntityName();
        EntityPersister entityDescriptor = typeConfiguration.getSessionFactory().getMetamodel().getEntityDescriptor(entityName);
        entityDescriptor.visitSubParts(valueMapping -> valueMapping.visitJdbcTypes(action, Clause.IRRELEVANT, typeConfiguration), entityDescriptor);
    }
}

