/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedRoot;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmRoot<E>
extends AbstractSqmFrom<E, E>
implements JpaRoot<E>,
DomainResultProducer<E> {
    public SqmRoot(EntityDomainType<E> entityType, String alias, NodeBuilder nodeBuilder) {
        super(entityType, alias, nodeBuilder);
    }

    @Override
    public SqmPath<?> getLhs() {
        return null;
    }

    @Override
    public SqmRoot findRoot() {
        return this;
    }

    @Override
    public EntityDomainType<E> getReferencedPathSource() {
        return (EntityDomainType)super.getReferencedPathSource();
    }

    public String getEntityName() {
        return this.getReferencedPathSource().getHibernateEntityName();
    }

    @Override
    public JavaTypeDescriptor<E> getJavaTypeDescriptor() {
        return this.getReferencedPathSource().getExpressableJavaTypeDescriptor();
    }

    @Override
    public String toString() {
        return this.getExplicitAlias() == null ? this.getEntityName() : this.getEntityName() + " as " + this.getExplicitAlias();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitRootPath(this);
    }

    @Override
    public EntityDomainType<E> getManagedType() {
        return this.getReferencedPathSource();
    }

    @Override
    public <X> JpaEntityJoin<X> join(Class<X> entityJavaType) {
        return this.join((EntityDomainType<X>)this.nodeBuilder().getDomainModel().entity((Class)entityJavaType));
    }

    @Override
    public <X> JpaEntityJoin<X> join(EntityDomainType<X> entity) {
        SqmEntityJoin<X> join = new SqmEntityJoin<X>(entity, null, SqmJoinType.CROSS, this);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public EntityDomainType<E> getModel() {
        return this.getReferencedPathSource();
    }

    @Override
    public <S extends E> SqmTreatedRoot<E, S> treatAs(Class<S> treatJavaType) throws PathException {
        return (SqmTreatedRoot)this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    @Override
    public <S extends E> SqmTreatedPath<E, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        return new SqmTreatedRoot(this, treatTarget, this.nodeBuilder());
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, TypeConfiguration typeConfiguration) {
        String entityName = this.getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = typeConfiguration.getSessionFactory().getMetamodel().getEntityDescriptor(entityName);
        entityDescriptor.visitSubParts(valueMapping -> valueMapping.visitJdbcTypes(action, Clause.IRRELEVANT, typeConfiguration), entityDescriptor);
    }

    @Override
    public DomainResult<E> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        String entityName = this.getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        return entityDescriptor.createDomainResult(this.getNavigablePath(), creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(this.getNavigablePath()), resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        String entityName = this.getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        entityDescriptor.applySqlSelections(this.getNavigablePath(), creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(this.getNavigablePath()), creationState);
    }
}

