/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;

public abstract class AbstractSqmSelectQuery<T>
extends AbstractSqmNode
implements SqmSelectQuery<T> {
    private SqmQuerySpec<T> sqmQuerySpec;
    private Class resultType;

    public AbstractSqmSelectQuery(Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.sqmQuerySpec = new SqmQuerySpec(builder);
        this.resultType = resultType;
    }

    public AbstractSqmSelectQuery(SqmQuerySpec<T> sqmQuerySpec, NodeBuilder builder) {
        this(sqmQuerySpec.getSelectClause().getJavaType(), builder);
    }

    public Class getResultType() {
        return this.resultType;
    }

    protected void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        return this.sqmQuerySpec;
    }

    public void setQuerySpec(SqmQuerySpec<T> sqmQuerySpec) {
        this.sqmQuerySpec = sqmQuerySpec;
    }

    public Set<Root<?>> getRoots() {
        return this.sqmQuerySpec.getRoots();
    }

    @Override
    public <X> SqmRoot<X> from(Class<X> entityClass) {
        return this.addRoot(new SqmRoot(this.nodeBuilder().getDomainModel().entity((Class)entityClass), null, this.nodeBuilder()));
    }

    private <X> SqmRoot<X> addRoot(SqmRoot<X> root) {
        this.sqmQuerySpec.addRoot(root);
        return root;
    }

    @Override
    public <X> SqmRoot<X> from(EntityType<X> entityType) {
        return this.addRoot(new SqmRoot((EntityDomainType)entityType, null, this.nodeBuilder()));
    }

    public boolean isDistinct() {
        return this.sqmQuerySpec.isDistinct();
    }

    @Override
    public SqmSelectQuery<T> distinct(boolean distinct) {
        this.sqmQuerySpec.setDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        return this.sqmQuerySpec.getSelection();
    }

    @Override
    public SqmPredicate getRestriction() {
        return this.sqmQuerySpec.getRestriction();
    }

    @Override
    public SqmSelectQuery<T> where(Expression<Boolean> restriction) {
        this.sqmQuerySpec.setRestriction((Expression)restriction);
        return this;
    }

    @Override
    public SqmSelectQuery<T> where(Predicate ... restrictions) {
        this.sqmQuerySpec.setRestriction(restrictions);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.sqmQuerySpec.getGroupingExpressions();
    }

    @Override
    public SqmSelectQuery<T> groupBy(Expression<?> ... expressions) {
        return this.groupBy((List)Arrays.asList(expressions));
    }

    @Override
    public SqmSelectQuery<T> groupBy(List<Expression<?>> grouping) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupingExpressions(grouping);
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        return this.sqmQuerySpec.getGroupRestriction();
    }

    @Override
    public SqmSelectQuery<T> having(Expression<Boolean> booleanExpression) {
        this.sqmQuerySpec.setGroupRestriction(this.nodeBuilder().wrap((Expression)booleanExpression));
        return this;
    }

    @Override
    public SqmSelectQuery<T> having(Predicate ... predicates) {
        this.sqmQuerySpec.setGroupRestriction(this.nodeBuilder().wrap((Expression[])predicates));
        return this;
    }
}

