/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.cte.SqmCteConsumer;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmFromClauseContainer;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClauseContainer;
import org.hibernate.query.sqm.tree.select.SqmGroupByClause;
import org.hibernate.query.sqm.tree.select.SqmHavingClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.type.StandardBasicTypes;

public class SqmQuerySpec<T>
implements SqmCteConsumer,
SqmNode,
SqmFromClauseContainer,
SqmWhereClauseContainer,
JpaQueryStructure<T> {
    private final NodeBuilder nodeBuilder;
    private SqmFromClause fromClause;
    private SqmSelectClause selectClause;
    private SqmWhereClause whereClause;
    private SqmGroupByClause groupByClause;
    private SqmHavingClause havingClause;
    private SqmOrderByClause orderByClause;
    private SqmExpression limitExpression;
    private SqmExpression offsetExpression;

    public SqmQuerySpec(NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public SqmFromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(SqmFromClause fromClause) {
        this.fromClause = fromClause;
    }

    public SqmSelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(SqmSelectClause selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public void applyPredicate(SqmPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        this.whereClause.applyPredicate(predicate);
    }

    public SqmGroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupByClause(SqmGroupByClause groupByClause) {
        this.groupByClause = groupByClause;
    }

    public SqmHavingClause getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(SqmHavingClause havingClause) {
        this.havingClause = havingClause;
    }

    public SqmOrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(SqmOrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public SqmExpression getLimitExpression() {
        return this.limitExpression;
    }

    public void setLimitExpression(SqmExpression<?> limitExpression) {
        if (limitExpression != null) {
            limitExpression.applyInferableType(StandardBasicTypes.INTEGER);
        }
        this.limitExpression = limitExpression;
    }

    public SqmExpression getOffsetExpression() {
        return this.offsetExpression;
    }

    public void setOffsetExpression(SqmExpression<?> offsetExpression) {
        if (offsetExpression != null) {
            offsetExpression.applyInferableType(StandardBasicTypes.INTEGER);
        }
        this.offsetExpression = offsetExpression;
    }

    @Override
    public boolean isDistinct() {
        assert (this.getSelectClause() != null);
        return this.getSelectClause().isDistinct();
    }

    @Override
    public SqmQuerySpec setDistinct(boolean distinct) {
        assert (this.getSelectClause() != null);
        this.getSelectClause().makeDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        assert (this.getSelectClause() != null);
        return this.getSelectClause().resolveJpaSelection();
    }

    @Override
    public SqmQuerySpec setSelection(JpaSelection<T> selection) {
        assert (this.getSelectClause() != null);
        this.getSelectClause().setSelection((SqmSelectableNode)selection);
        return this;
    }

    @Override
    public Set getRoots() {
        assert (this.getFromClause() != null);
        return new HashSet<SqmRoot>(this.getFromClause().getRoots());
    }

    @Override
    public SqmQuerySpec addRoot(JpaRoot<?> root) {
        if (this.getFromClause() == null) {
            this.setFromClause(new SqmFromClause());
        }
        this.getFromClause().addRoot((SqmRoot)root);
        return this;
    }

    @Override
    public SqmPredicate getRestriction() {
        if (this.getWhereClause() == null) {
            return null;
        }
        return this.getWhereClause().getPredicate();
    }

    @Override
    public SqmQuerySpec<T> setRestriction(JpaPredicate restriction) {
        if (this.getWhereClause() == null) {
            this.setWhereClause(new SqmWhereClause(this.nodeBuilder()));
        }
        this.getWhereClause().setPredicate((SqmPredicate)restriction);
        return this;
    }

    @Override
    public SqmQuerySpec<T> setRestriction(Expression<Boolean> restriction) {
        if (this.getWhereClause() == null) {
            this.setWhereClause(new SqmWhereClause(this.nodeBuilder()));
        }
        this.getWhereClause().setPredicate((SqmPredicate)this.nodeBuilder.wrap((Expression)restriction));
        return this;
    }

    @Override
    public SqmQuerySpec<T> setRestriction(Predicate ... restrictions) {
        if (this.getWhereClause() == null) {
            this.setWhereClause(new SqmWhereClause(this.nodeBuilder()));
        }
        this.getWhereClause().applyPredicates((SqmPredicate[])restrictions);
        return null;
    }

    @Override
    public List<SqmExpression> getGroupingExpressions() {
        if (this.getGroupByClause() == null) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> list = new ArrayList<SqmExpression>();
        this.getGroupByClause().visitGroupings(sqmGrouping -> list.add(sqmGrouping.getExpression()));
        return list;
    }

    @Override
    public SqmQuerySpec<T> setGroupingExpressions(List<? extends JpaExpression<?>> groupExpressions) {
        if (this.getGroupByClause() == null) {
            this.setGroupByClause(new SqmGroupByClause());
        } else {
            this.getGroupByClause().clearGroupings();
        }
        for (JpaExpression<?> groupExpression : groupExpressions) {
            this.getGroupByClause().addGrouping((SqmExpression)groupExpression);
        }
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupingExpressions(JpaExpression<?> ... groupExpressions) {
        if (this.getGroupByClause() == null) {
            this.setGroupByClause(new SqmGroupByClause());
        } else {
            this.getGroupByClause().clearGroupings();
        }
        for (JpaExpression<?> groupExpression : groupExpressions) {
            this.getGroupByClause().addGrouping((SqmExpression)groupExpression);
        }
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        if (this.getHavingClause() == null) {
            return null;
        }
        return this.getHavingClause().getPredicate();
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(JpaPredicate restriction) {
        if (this.getHavingClause() == null) {
            this.setHavingClause(new SqmHavingClause((SqmPredicate)restriction));
        } else {
            this.getHavingClause().setPredicate((SqmPredicate)restriction);
        }
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(Expression<Boolean> restriction) {
        JpaPredicate predicate = this.nodeBuilder.wrap((Expression)restriction);
        if (this.getHavingClause() == null) {
            this.setHavingClause(new SqmHavingClause((SqmPredicate)predicate));
        } else {
            this.getHavingClause().setPredicate((SqmPredicate)predicate);
        }
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(Predicate ... restrictions) {
        JpaPredicate predicate = this.nodeBuilder.wrap((Expression[])restrictions);
        if (this.getHavingClause() == null) {
            this.setHavingClause(new SqmHavingClause((SqmPredicate)predicate));
        } else {
            this.getHavingClause().setPredicate((SqmPredicate)predicate);
        }
        return this;
    }

    @Override
    public List<SqmSortSpecification> getSortSpecifications() {
        if (this.getOrderByClause() == null) {
            return Collections.emptyList();
        }
        return this.getOrderByClause().getSortSpecifications();
    }

    @Override
    public SqmQuerySpec<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        if (this.getOrderByClause() == null) {
            this.setOrderByClause(new SqmOrderByClause());
        }
        this.getOrderByClause().setSortSpecifications(sortSpecifications);
        return this;
    }

    public SqmExpression getLimit() {
        return this.getLimitExpression();
    }

    @Override
    public SqmQuerySpec<T> setLimit(JpaExpression<?> limit) {
        this.setLimitExpression((SqmExpression)limit);
        return this;
    }

    public SqmExpression getOffset() {
        return this.getOffsetExpression();
    }

    @Override
    public SqmQuerySpec<T> setOffset(JpaExpression offset) {
        this.setOffsetExpression((SqmExpression)offset);
        return this;
    }
}

