/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.sql.ast.SqlAstInsertTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class StandardSqlAstInsertTranslator
extends AbstractSqlAstTranslator
implements SqlAstInsertTranslator {
    public StandardSqlAstInsertTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public JdbcInsert translate(InsertStatement sqlAst) {
        this.appendSql("insert into ");
        this.appendSql(sqlAst.getTargetTable().getTableExpression());
        this.appendSql(" (");
        boolean firstPass = true;
        List<ColumnReference> targetColumnReferences = sqlAst.getTargetColumnReferences();
        if (targetColumnReferences == null) {
            this.renderImplicitTargetColumnSpec();
        } else {
            for (ColumnReference targetColumnReference : targetColumnReferences) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(", ");
                }
                this.appendSql(targetColumnReference.getColumnExpression());
            }
        }
        this.appendSql(") ");
        if (sqlAst.getSourceSelectStatement() != null) {
            this.visitQuerySpec(sqlAst.getSourceSelectStatement());
        } else {
            this.appendSql("values");
            boolean firstTuple = true;
            for (Values values : sqlAst.getValuesList()) {
                if (firstTuple) {
                    firstTuple = false;
                } else {
                    this.appendSql(", ");
                }
                this.appendSql(" (");
                boolean firstExpr = true;
                for (Expression expression : values.getExpressions()) {
                    if (firstExpr) {
                        firstExpr = false;
                    } else {
                        this.appendSql(", ");
                    }
                    expression.accept(this);
                }
                this.appendSql(")");
            }
        }
        return new JdbcInsert(){

            @Override
            public String getSql() {
                return StandardSqlAstInsertTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstInsertTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstInsertTranslator.this.getAffectedTableNames();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return StandardSqlAstInsertTranslator.this.getFilterJdbcParameters();
            }
        };
    }

    private void renderImplicitTargetColumnSpec() {
    }

    @Override
    public JdbcInsert translate(CteStatement sqlAst) {
        assert (sqlAst.getCteConsumer() instanceof InsertStatement);
        this.appendSql("with ");
        this.appendSql(sqlAst.getCteLabel());
        this.appendSql(" (");
        String separator = "";
        for (CteColumn cteColumn : sqlAst.getCteTable().getCteColumns()) {
            this.appendSql(separator);
            this.appendSql(cteColumn.getColumnExpression());
            separator = ", ";
        }
        this.appendSql(") as (");
        this.visitQuerySpec(sqlAst.getCteDefinition());
        this.appendSql(") ");
        this.translate((InsertStatement)sqlAst.getCteConsumer());
        return new JdbcInsert(){

            @Override
            public String getSql() {
                return StandardSqlAstInsertTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstInsertTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstInsertTranslator.this.getAffectedTableNames();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return StandardSqlAstInsertTranslator.this.getFilterJdbcParameters();
            }
        };
    }
}

