/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.sql.ast.SqlAstUpdateTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class StandardSqlAstUpdateTranslator
extends AbstractSqlAstTranslator
implements SqlAstUpdateTranslator {
    private String updatingTableAlias;

    public StandardSqlAstUpdateTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public JdbcUpdate translate(UpdateStatement sqlAst) {
        this.updatingTableAlias = sqlAst.getTargetTable().getIdentificationVariable();
        this.appendSql("update ");
        this.appendSql(sqlAst.getTargetTable().getTableExpression());
        this.appendSql(" set ");
        boolean firstPass = true;
        for (Assignment assignment : sqlAst.getAssignments()) {
            if (firstPass) {
                firstPass = false;
            } else {
                this.appendSql(", ");
            }
            List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
            if (columnReferences.size() == 1) {
                columnReferences.get(0).accept(this);
            } else {
                this.appendSql(" (");
                for (ColumnReference columnReference : columnReferences) {
                    columnReference.accept(this);
                }
                this.appendSql(") ");
            }
            this.appendSql(" = ");
            assignment.getAssignedValue().accept(this);
        }
        if (sqlAst.getRestriction() != null) {
            this.appendSql(" where ");
            sqlAst.getRestriction().accept(this);
        }
        return new JdbcUpdate(){

            @Override
            public String getSql() {
                return StandardSqlAstUpdateTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstUpdateTranslator.this.getParameterBinders();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return StandardSqlAstUpdateTranslator.this.getFilterJdbcParameters();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstUpdateTranslator.this.getAffectedTableNames();
            }
        };
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        if (this.updatingTableAlias != null && this.updatingTableAlias.equals(columnReference.getQualifier())) {
            this.appendSql(columnReference.getColumnExpression());
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    @Override
    public JdbcUpdate translate(CteStatement cteStatement) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

