/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.delete;

import org.hibernate.sql.ast.spi.SqlAstHelper;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.cte.CteConsumer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class DeleteStatement
implements MutationStatement,
CteConsumer {
    private final TableReference targetTable;
    private final Predicate restriction;

    public DeleteStatement(TableReference targetTable, Predicate restriction) {
        this.targetTable = targetTable;
        this.restriction = restriction;
    }

    public TableReference getTargetTable() {
        return this.targetTable;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public static class DeleteStatementBuilder {
        private final TableReference targetTable;
        private Predicate restriction;

        public DeleteStatementBuilder(TableReference targetTable) {
            this.targetTable = targetTable;
        }

        public DeleteStatementBuilder addRestriction(Predicate restriction) {
            this.restriction = SqlAstHelper.combinePredicates(this.restriction, restriction);
            return this;
        }

        public DeleteStatementBuilder setRestriction(Predicate restriction) {
            this.restriction = restriction;
            return this;
        }

        public DeleteStatement createDeleteStatement() {
            return new DeleteStatement(this.targetTable, this.restriction != null ? this.restriction : new Junction(Junction.Nature.CONJUNCTION));
        }
    }
}

