/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;

public class CaseSearchedExpression
implements Expression,
DomainResultProducer {
    private final BasicType type;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private Expression otherwise;

    public CaseSearchedExpression(MappingModelExpressable type) {
        this.type = (BasicType)type;
    }

    public CaseSearchedExpression(MappingModelExpressable type, List<WhenFragment> whenFragments, Expression otherwise) {
        this.type = (BasicType)type;
        this.whenFragments = whenFragments;
        this.otherwise = otherwise;
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public Expression getOtherwise() {
        return this.otherwise;
    }

    public void when(Predicate predicate, Expression result) {
        this.whenFragments.add(new WhenFragment(predicate, result));
    }

    public void otherwise(Expression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getExpressableJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getExpressableJavaTypeDescriptor());
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitCaseSearchedExpression(this);
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.type;
    }

    public static class WhenFragment {
        private final Predicate predicate;
        private final Expression result;

        public WhenFragment(Predicate predicate, Expression result) {
            this.predicate = predicate;
            this.result = result;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public Expression getResult() {
            return this.result;
        }
    }
}

