/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryLiteral<T>
implements Literal,
DomainResultProducer<T> {
    private final T value;
    private final BasicValuedMapping type;

    public QueryLiteral(T value, BasicValuedMapping type) {
        this.value = value;
        this.type = type;
    }

    public T getLiteralValue() {
        return this.value;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type.getJdbcMapping();
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitQueryLiteral(this);
    }

    @Override
    public BasicValuedMapping getExpressionType() {
        return this.type;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.type.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getMappedTypeDescriptor().getMappedJavaTypeDescriptor());
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, TypeConfiguration typeConfiguration) {
        action.accept(this.type.getJdbcMapping());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        ((BasicType)this.getExpressionType()).getJdbcValueBinder().bind(statement, this.getLiteralValue(), startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getJdbcMapping().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }
}

