/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class StandardTableGroup
extends AbstractTableGroup {
    private final TableReference primaryTableReference;
    private final Predicate<String> tableReferenceJoinNameChecker;
    private final BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator;
    private List<TableReferenceJoin> tableJoins;

    public StandardTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, LockMode lockMode, TableReference primaryTableReference, List<TableReferenceJoin> tableJoins, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        super(navigablePath, tableGroupProducer, lockMode, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.tableJoins = tableJoins;
        this.tableReferenceJoinCreator = null;
        this.tableReferenceJoinNameChecker = s -> {
            for (int i = 0; i < tableJoins.size(); ++i) {
                if (!((TableReferenceJoin)tableJoins.get(i)).getJoinedTableReference().getTableExpression().equals(s)) continue;
                return true;
            }
            return false;
        };
    }

    public StandardTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, LockMode lockMode, TableReference primaryTableReference, SqlAliasBase sqlAliasBase, Predicate<String> tableReferenceJoinNameChecker, BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator, SessionFactoryImplementor sessionFactory) {
        super(navigablePath, tableGroupProducer, lockMode, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.tableJoins = null;
        this.tableReferenceJoinNameChecker = tableReferenceJoinNameChecker;
        this.tableReferenceJoinCreator = tableReferenceJoinCreator;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.getPrimaryTableReference().getTableExpression());
        for (TableReferenceJoin tableReferenceJoin : this.tableJoins) {
            nameCollector.accept(tableReferenceJoin.getJoinedTableReference().getTableExpression());
        }
    }

    @Override
    public TableReference getTableReference(String tableExpression) {
        return this.getTableReferenceInternal(tableExpression);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableJoins == null ? Collections.emptyList() : this.tableJoins;
    }

    public void addTableReferenceJoin(TableReferenceJoin join) {
        if (this.tableJoins == null) {
            this.tableJoins = new ArrayList<TableReferenceJoin>();
        }
        this.tableJoins.add(join);
    }

    @Override
    public TableReference getTableReferenceInternal(String tableExpression) {
        TableReference tableReference = this.primaryTableReference.getTableReference(tableExpression);
        if (tableReference != null) {
            return tableReference;
        }
        if (this.tableReferenceJoinNameChecker.test(tableExpression)) {
            if (this.tableJoins != null) {
                for (int i = 0; i < this.tableJoins.size(); ++i) {
                    TableReferenceJoin join = this.tableJoins.get(i);
                    assert (join != null);
                    if (!join.getJoinedTableReference().getTableExpression().equals(tableExpression)) continue;
                    return join.getJoinedTableReference();
                }
            }
            return this.potentiallyCreateTableReference(tableExpression);
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference();
            if (primaryTableReference.getTableReference(tableExpression) == null) continue;
            return primaryTableReference;
        }
        return null;
    }

    protected TableReference potentiallyCreateTableReference(String tableExpression) {
        TableReferenceJoin join = this.tableReferenceJoinCreator.apply(tableExpression, this);
        if (join != null) {
            this.addTableReferenceJoin(join);
            return join.getJoinedTableReference();
        }
        return null;
    }
}

