/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class UnionTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private Set<TableGroupJoin> tableGroupJoins;
    private final UnionSubclassEntityPersister modelPart;
    private final TableReference tableReference;

    public UnionTableGroup(NavigablePath navigablePath, TableReference tableReference, UnionSubclassEntityPersister modelPart) {
        this.navigablePath = navigablePath;
        this.tableReference = tableReference;
        this.modelPart = modelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.modelPart;
    }

    @Override
    public LockMode getLockMode() {
        return LockMode.NONE;
    }

    @Override
    public Set<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptySet() : Collections.unmodifiableSet(this.tableGroupJoins);
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void setTableGroupJoins(Set<TableGroupJoin> joins) {
        this.tableGroupJoins = new HashSet<TableGroupJoin>(joins);
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>();
        }
        this.tableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.tableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public boolean isInnerJoinPossible() {
        return false;
    }

    @Override
    public TableReference getTableReference(String tableExpression) {
        return this.tableReference;
    }

    @Override
    public TableReference resolveTableReference(String tableExpression, Supplier<TableReference> creator) {
        assert (this.tableReference.getTableExpression().equals(tableExpression));
        return this.tableReference;
    }

    @Override
    public TableReference resolveTableReference(String tableExpression) {
        return this.tableReference;
    }
}

