/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.update;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.cte.CteConsumer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;

public class UpdateStatement
implements MutationStatement,
CteConsumer {
    private final TableReference targetTable;
    private final List<Assignment> assignments;
    private final Predicate restriction;

    public UpdateStatement(TableReference targetTable, List<Assignment> assignments, Predicate restriction) {
        this.targetTable = targetTable;
        this.assignments = assignments;
        this.restriction = restriction;
    }

    public TableReference getTargetTable() {
        return this.targetTable;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public static class UpdateStatementBuilder {
        private final TableReference targetTableRef;
        private List<Assignment> assignments;
        private Predicate restriction;

        public UpdateStatementBuilder(TableReference targetTableRef) {
            this.targetTableRef = targetTableRef;
        }

        public UpdateStatementBuilder addAssignment(Assignment assignment) {
            if (this.assignments == null) {
                this.assignments = new ArrayList<Assignment>();
            }
            this.assignments.add(assignment);
            return this;
        }

        public UpdateStatementBuilder addRestriction(Predicate restriction) {
            this.restriction = SqlAstTreeHelper.combinePredicates(this.restriction, restriction);
            return this;
        }

        public UpdateStatementBuilder setRestriction(Predicate restriction) {
            this.restriction = restriction;
            return this;
        }

        public UpdateStatement createUpdateAst() {
            if (this.assignments == null || this.assignments.isEmpty()) {
                return null;
            }
            return new UpdateStatement(this.targetTableRef, this.assignments, this.restriction);
        }
    }
}

