/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractJdbcParameter
implements JdbcParameter,
JdbcParameterBinder,
MappingModelExpressable,
SqlExpressable {
    private final JdbcMapping jdbcMapping;

    public AbstractJdbcParameter(JdbcMapping jdbcMapping) {
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this);
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
        JdbcParameterBinding binding = jdbcParamBindings.getBinding(this);
        if (binding == null) {
            throw new ExecutionException("JDBC parameter value not bound - " + this);
        }
        JdbcMapping jdbcMapping = binding.getBindType();
        if (jdbcMapping == null) {
            jdbcMapping = this.jdbcMapping;
        }
        if (jdbcMapping == null) {
            jdbcMapping = this.guessBindType(executionContext, binding);
        }
        Object bindValue = binding.getBindValue();
        jdbcMapping.getJdbcValueBinder().bind(statement, bindValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    private JdbcMapping guessBindType(ExecutionContext executionContext, JdbcParameterBinding binding) {
        BasicType basicType = executionContext.getSession().getFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(binding.getBindValue().getClass());
        return basicType.getJdbcMapping();
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.jdbcMapping);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public void visitDisassembledJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.jdbcMapping);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.jdbcMapping);
    }
}

