/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer
implements CollectionInitializer {
    private final NavigablePath collectionPath;
    protected final PluralAttributeMapping collectionAttributeMapping;
    protected final FetchParentAccess parentAccess;
    protected PersistentCollection collectionInstance;
    protected CollectionKey collectionKey;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess) {
        this.collectionPath = collectionPath;
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.parentAccess = parentAccess;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        Object parentKey = this.parentAccess.getParentKey();
        if (parentKey != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), parentKey);
            this.parentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
        }
    }

    @Override
    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    protected FetchParentAccess getParentAccess() {
        return this.parentAccess;
    }

    @Override
    public CollectionKey resolveCollectionKey(RowProcessingState rowProcessingState) {
        this.resolveKey(rowProcessingState);
        return this.collectionKey;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.collectionKey = null;
    }
}

