/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractEmbeddableInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embeddedModelPartDescriptor;
    private FetchParentAccess fetchParentAccess;
    private final Map<StateArrayContributorMapping, DomainResultAssembler> assemblerMap;
    private final Object[] resolvedValues;
    private final boolean createEmptyCompositesEnabled;
    private Object compositeInstance;

    public AbstractEmbeddableInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess fetchParentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embeddedModelPartDescriptor = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        EmbeddableMappingType embeddableTypeDescriptor = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor();
        int numOfAttrs = embeddableTypeDescriptor.getNumberOfAttributeMappings();
        this.resolvedValues = new Object[numOfAttrs];
        this.assemblerMap = new IdentityHashMap<StateArrayContributorMapping, DomainResultAssembler>(numOfAttrs);
        embeddableTypeDescriptor.visitStateArrayContributors(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch((Fetchable)stateArrayContributor);
            DomainResultAssembler stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaTypeDescriptor()) : fetch.createAssembler(this, creationState);
            this.assemblerMap.put((StateArrayContributorMapping)stateArrayContributor, stateAssembler);
        });
        this.createEmptyCompositesEnabled = embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embeddedModelPartDescriptor;
    }

    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        PropertyAccess parentInjectionPropertyAccess = this.embeddedModelPartDescriptor.getParentInjectionAttributePropertyAccess();
        FetchParentAccess fetchParentAccess = this.getFetchParentAccess();
        if (parentInjectionPropertyAccess != null && fetchParentAccess != null) {
            fetchParentAccess.findFirstEntityDescriptorAccess().registerResolutionListener(owner -> {
                if (this.compositeInstance == null) {
                    return;
                }
                parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            });
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        this.compositeInstance = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(rowProcessingState.getSession().getFactory());
        EmbeddableLoadingLogger.INSTANCE.debugf("Created composite instance [%s] : %s", (Object)this.navigablePath, this.compositeInstance);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        PropertyAccess parentInjectionPropertyAccess = this.embeddedModelPartDescriptor.getParentInjectionAttributePropertyAccess();
        if (parentInjectionPropertyAccess != null) {
            Object owner;
            Initializer initializer = rowProcessingState.resolveInitializer(this.navigablePath.getParent());
            if (initializer instanceof CollectionInitializer) {
                owner = ((CollectionInitializer)initializer).getCollectionInstance().getOwner();
            } else if (initializer instanceof EntityInitializer) {
                owner = ((EntityInitializer)initializer).getEntityInstance();
                parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            } else {
                throw new NotYetImplementedFor6Exception(this.getClass());
            }
            parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
        }
        EmbeddableLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s] : %s", (Object)this.navigablePath, this.compositeInstance);
        boolean areAllValuesNull = true;
        for (Map.Entry<StateArrayContributorMapping, DomainResultAssembler> entry : this.assemblerMap.entrySet()) {
            Object contributorValue = entry.getValue().assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.resolvedValues[entry.getKey().getStateArrayPosition()] = contributorValue;
            if (contributorValue == null) continue;
            areAllValuesNull = false;
        }
        if (!this.createEmptyCompositesEnabled && areAllValuesNull) {
            this.compositeInstance = null;
        } else {
            this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().setPropertyValues(this.compositeInstance, this.resolvedValues);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.getFetchParentAccess().findFirstEntityDescriptorAccess();
    }
}

