/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogger;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.TypeHelper;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private EntityPersister concreteDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final List<Initializer> identifierInitializers = new ArrayList<Initializer>();
    private final DomainResultAssembler identifierAssembler;
    private final DomainResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final Map<AttributeMapping, DomainResultAssembler> assemblerMap;
    private final EntityValuedModelPart referencedModelPart;
    private EntityKey entityKey;
    private Object entityInstance;
    private boolean missing;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, DomainResult<?> identifierResult, DomainResult<?> discriminatorResult, DomainResult<?> versionResult, DomainResult<Object> rowIdResult, final AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : creationState.getSqlAstCreationContext().getDomainModel().findEntityDescriptor(rootEntityName);
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.identifierAssembler = identifierResult != null ? identifierResult.createResultAssembler(new AssemblerCreationState(){

            @Override
            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                for (int i = 0; i < AbstractEntityInitializer.this.identifierInitializers.size(); ++i) {
                    Initializer existing = (Initializer)AbstractEntityInitializer.this.identifierInitializers.get(i);
                    if (!existing.getNavigablePath().equals(navigablePath) || !fetchedModelPart.getNavigableRole().equals(existing.getInitializedPart().getNavigableRole())) continue;
                    return existing;
                }
                Initializer initializer = producer.get();
                AbstractEntityInitializer.this.identifierInitializers.add(initializer);
                return initializer;
            }

            @Override
            public SqlAstCreationContext getSqlAstCreationContext() {
                return creationState.getSqlAstCreationContext();
            }
        }) : null;
        this.discriminatorAssembler = discriminatorResult != null ? discriminatorResult.createResultAssembler(creationState) : null;
        this.versionAssembler = versionResult != null ? versionResult.createResultAssembler(creationState) : null;
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(creationState) : null;
        this.assemblerMap = new IdentityHashMap<AttributeMapping, DomainResultAssembler>(this.entityDescriptor.getNumberOfAttributeMappings());
        this.entityDescriptor.visitFetchables(fetchable -> {
            AttributeMapping attributeMapping = (AttributeMapping)fetchable;
            Fetch fetch = resultDescriptor.findFetch((Fetchable)fetchable);
            NullValueAssembler stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedTypeDescriptor().getMappedJavaTypeDescriptor()) : fetch.createAssembler(this, creationState);
            this.assemblerMap.put(attributeMapping, stateAssembler);
        }, null);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        if (this.entityKey == null) {
            return null;
        }
        return this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public Object getFetchParentInstance() {
        if (this.entityInstance == null) {
            throw new IllegalStateException("Unexpected state condition - entity instance not yet resolved");
        }
        return this.entityInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath().getFullPath());
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        if (this.concreteDescriptor == null) {
            this.missing = true;
            return;
        }
        this.initializeIdentifier(rowProcessingState);
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogger.LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), (Object)this.entityKey.getIdentifier());
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorValue = this.discriminatorAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        String concreteEntityName = ((Loadable)this.entityDescriptor).getSubclassForDiscriminatorValue(discriminatorValue);
        if (concreteEntityName == null) {
            return null;
        }
        EntityPersister concreteType = session.getFactory().getMetamodel().findEntityDescriptor(concreteEntityName);
        assert (concreteType.isTypeOrSuperType(this.entityDescriptor));
        return concreteType;
    }

    protected void initializeIdentifier(RowProcessingState rowProcessingState) {
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#initializeIdentifier process for entity (%s) ", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
        this.identifierInitializers.forEach(initializer -> initializer.resolveKey(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.resolveInstance(rowProcessingState));
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Fiish Initializer#initializeIdentifier process for entity (%s) ", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        Object id = this.identifierAssembler == null ? jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId() : this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor);
        if (jdbcValuesSourceProcessingState.findInitializer(this.entityKey) == null) {
            jdbcValuesSourceProcessingState.registerInitilaizer(this.entityKey, this);
        }
        if (this.concreteDescriptor.isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        Object entity;
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        Object existingEntity;
        if (this.missing) {
            return;
        }
        this.identifierInitializers.forEach(initializer -> initializer.initializeInstance(rowProcessingState));
        Serializable entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), (Object)entityIdentifier);
        }
        if ((existingEntity = (persistenceContext = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext()).getEntity(this.entityKey)) != null) {
            this.entityInstance = existingEntity;
            return;
        }
        LoadingEntityEntry existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey);
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
                }
                return;
            }
        }
        if (this.entityInstance == null && this.isEntityReturn()) {
            Object requestedEntityId = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalId();
            Object optionalEntityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
            if (requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier())) {
                this.entityInstance = optionalEntityInstance;
            }
        }
        if (this.entityInstance == null && (entity = persistenceContext.getEntity(this.entityKey)) != null) {
            this.entityInstance = entity;
        }
        if (this.entityInstance == null) {
            this.entityInstance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier), this.entityInstance);
            }
            LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, this.entityInstance);
            rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
        }
        this.notifyParentResolutionListeners(this.entityInstance);
        this.preLoad(rowProcessingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        Status status;
        if (this.missing) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (persistenceContext.getEntity(this.entityKey) != null) {
            return;
        }
        Serializable entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
        }
        if (persistenceContext.containsEntity(this.entityKey) && ((status = persistenceContext.getEntry(persistenceContext.getEntity(this.entityKey)).getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        this.entityDescriptor.setIdentifier(this.entityInstance, entityIdentifier, session);
        this.resolvedEntityState = this.concreteDescriptor.extractConcreteTypeStateValues(this.assemblerMap, rowProcessingState);
        this.concreteDescriptor.setPropertyValues(this.entityInstance, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, this.entityInstance);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        EntityEntry entityEntry = persistenceContext.addEntry(this.entityInstance, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, this.lockMode, true, this.concreteDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        if (cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
            }
            CacheEntry entry = this.concreteDescriptor.buildCacheEntry(this.entityInstance, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(entry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(entry), version, false);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(this.entityDescriptor, entityIdentifier, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(this.resolvedEntityState, this.entityDescriptor));
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.concreteDescriptor.isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(this.entityKey);
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState, attributeMapping -> attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(this.concreteDescriptor).isUpdatable());
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.concreteDescriptor.afterInitialize(this.entityInstance, session);
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().loadEntity(this.concreteDescriptor.getEntityName());
        }
        this.postLoad(rowProcessingState);
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        if (persistenceContext.isDefaultReadOnly()) {
            return true;
        }
        Boolean queryOption = rowProcessingState.getJdbcValuesSourceProcessingState().getQueryOptions().isReadOnly();
        return queryOption == null ? false : queryOption;
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    private void postLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PostLoadEvent postLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPostLoadEvent();
            assert (postLoadEvent != null);
            postLoadEvent.reset();
            postLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PostLoadEventListener> listenerGroup = this.entityDescriptor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPostLoad(postLoadEvent);
            }
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.clearParentResolutionListeners();
    }
}

