/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntityDelayedFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResultAssembler identifierAssembler;
    private Object entityInstance;
    private Object identifier;

    public EntityDelayedFetchInitializer(NavigablePath fetchedNavigable, EntityValuedModelPart referencedModelPart, DomainResultAssembler identifierAssembler) {
        this.navigablePath = fetchedNavigable;
        this.referencedModelPart = referencedModelPart;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        this.identifier = this.identifierAssembler.assemble(rowProcessingState);
        if (this.identifier == null) {
            this.entityInstance = null;
        } else {
            EntityPersister concreteDescriptor = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            EntityKey entityKey = new EntityKey(this.identifier, concreteDescriptor);
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContext();
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null) {
                this.entityInstance = entity;
            } else {
                LoadingEntityEntry loadingEntityLocally = rowProcessingState.getJdbcValuesSourceProcessingState().findLoadingEntityLocally(entityKey);
                if (loadingEntityLocally != null) {
                    this.entityInstance = loadingEntityLocally.getEntityInstance();
                } else if (concreteDescriptor.hasProxy()) {
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy != null) {
                        this.entityInstance = proxy;
                    } else {
                        this.entityInstance = concreteDescriptor.createProxy(this.identifier, rowProcessingState.getSession());
                        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
                        persistenceContext.addProxy(entityKey, this.entityInstance);
                    }
                } else if (concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                    this.entityInstance = concreteDescriptor.instantiate(this.identifier, rowProcessingState.getSession());
                }
            }
            this.notifyParentResolutionListeners(this.entityInstance);
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.identifier = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.referencedModelPart.getEntityMappingType().getEntityPersister();
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    public String toString() {
        return "EntityDelayedFetchInitializer(" + LoggingHelper.toLoggableString(this.navigablePath) + ")";
    }
}

