/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogger;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntitySelectFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private static final String CONCRETE_NAME = EntitySelectFetchInitializer.class.getSimpleName();
    private final NavigablePath navigablePath;
    private final boolean isEnhancedForLazyLoading;
    private final boolean nullable;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler identifierAssembler;
    private final EntityValuedModelPart referencedModelPart;
    protected Object entityInstance;

    public EntitySelectFetchInitializer(EntityValuedModelPart referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler, boolean nullable) {
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
        this.nullable = nullable;
        this.referencedModelPart = referencedModelPart;
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        String entityName = this.concreteDescriptor.getEntityName();
        EntityKey entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
        Initializer initializer = rowProcessingState.getJdbcValuesSourceProcessingState().findInitializer(entityKey);
        if (initializer != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found an initializer for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
            }
            initializer.resolveInstance(rowProcessingState);
            this.entityInstance = initializer.getInitializedInstance();
            return;
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(entityKey);
        if (this.entityInstance != null) {
            return;
        }
        LoadingEntityEntry existingLoadingEntry = session.getPersistenceContext().getLoadContexts().findLoadingEntityEntry(entityKey);
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
                }
                return;
            }
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Invoking session#internalLoad for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        this.entityInstance = session.internalLoad(entityName, entityIdentifier, true, this.nullable);
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] : %s has being loaded by session.internalLoad.", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        if (this.entityInstance instanceof HibernateProxy && this.isEnhancedForLazyLoading) {
            ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer().setUnwrap(true);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

