/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.sqm.tree.expression.Compatibility;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.instantiation.DynamicInstantiationResult;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentDomainResult;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerConstructorImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerInjectionImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerListImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerMapImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class DynamicInstantiationResultImpl<R>
implements DynamicInstantiationResult<R> {
    private static final Logger log = Logger.getLogger(DynamicInstantiationResultImpl.class);
    private final String resultVariable;
    private final DynamicInstantiationNature nature;
    private final JavaTypeDescriptor<R> javaTypeDescriptor;
    private final List<ArgumentDomainResult<?>> argumentResults;

    public DynamicInstantiationResultImpl(String resultVariable, DynamicInstantiationNature nature, JavaTypeDescriptor<R> javaTypeDescriptor, List<ArgumentDomainResult<?>> argumentResults) {
        this.resultVariable = resultVariable;
        this.nature = nature;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.argumentResults = argumentResults;
    }

    @Override
    public JavaTypeDescriptor<R> getResultJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        for (int i = 0; i < this.argumentResults.size(); ++i) {
            ArgumentDomainResult<?> argumentResult = this.argumentResults.get(i);
            if (!argumentResult.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public DomainResultAssembler<R> createResultAssembler(AssemblerCreationState creationState) {
        boolean areAllArgumentsAliased = true;
        boolean areAnyArgumentsAliased = false;
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<String> duplicatedAliases = new ArrayList<String>();
        ArrayList argumentReaders = new ArrayList();
        if (this.argumentResults != null) {
            for (ArgumentDomainResult<?> argumentResult : this.argumentResults) {
                String argumentAlias = argumentResult.getResultVariable();
                if (argumentAlias == null) {
                    areAllArgumentsAliased = false;
                } else {
                    if (!aliases.add(argumentAlias)) {
                        duplicatedAliases.add(argumentAlias);
                        log.debugf("Query defined duplicate resultVariable encountered multiple declarations of [%s]", (Object)argumentAlias);
                    }
                    areAnyArgumentsAliased = true;
                }
                argumentReaders.add((ArgumentReader<?>)argumentResult.createResultAssembler(creationState));
            }
        }
        return this.resolveAssembler(areAllArgumentsAliased, areAnyArgumentsAliased, duplicatedAliases, argumentReaders, creationState);
    }

    private DomainResultAssembler<R> resolveAssembler(boolean areAllArgumentsAliased, boolean areAnyArgumentsAliased, List<String> duplicatedAliases, List<ArgumentReader<?>> argumentReaders, AssemblerCreationState creationState) {
        if (this.nature == DynamicInstantiationNature.LIST) {
            if (log.isDebugEnabled() && areAnyArgumentsAliased) {
                log.debug((Object)"One or more arguments for List dynamic instantiation (`new list(...)`) specified an alias; ignoring");
            }
            return new DynamicInstantiationAssemblerListImpl(this.javaTypeDescriptor, argumentReaders);
        }
        if (this.nature == DynamicInstantiationNature.MAP) {
            if (!areAllArgumentsAliased) {
                throw new IllegalStateException("Map dynamic instantiation contained one or more arguments with no alias");
            }
            if (!duplicatedAliases.isEmpty()) {
                throw new IllegalStateException("Map dynamic instantiation contained arguments with duplicated aliases [" + StringHelper.join(",", duplicatedAliases) + "]");
            }
            return new DynamicInstantiationAssemblerMapImpl(this.javaTypeDescriptor, argumentReaders);
        }
        block0: for (Constructor<?> constructor : this.javaTypeDescriptor.getJavaType().getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != argumentReaders.size()) continue;
            for (int i = 0; i < argumentReaders.size(); ++i) {
                ArgumentReader<?> argumentReader = argumentReaders.get(i);
                JavaTypeDescriptor<?> argumentTypeDescriptor = creationState.getSqlAstCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(constructor.getParameterTypes()[i]);
                boolean assignmentCompatible = Compatibility.areAssignmentCompatible(argumentTypeDescriptor, argumentReader.getAssembledJavaTypeDescriptor());
                if (assignmentCompatible) continue;
                if (!log.isDebugEnabled()) continue block0;
                log.debugf("Skipping constructor for dynamic-instantiation match due to argument mismatch [%s] : %s -> %s", i, (Object)constructor.getParameterTypes()[i].getName(), (Object)argumentTypeDescriptor.getJavaType().getName());
                continue block0;
            }
            constructor.setAccessible(true);
            return new DynamicInstantiationAssemblerConstructorImpl(constructor, this.javaTypeDescriptor, argumentReaders);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Could not locate appropriate constructor for dynamic instantiation of [%s]; attempting bean-injection instantiation", (Object)this.javaTypeDescriptor.getJavaType().getName());
        }
        if (!areAllArgumentsAliased) {
            throw new IllegalStateException("Could not determine appropriate instantiation strategy - no matching constructor found and one or more arguments did not define alias for bean-injection");
        }
        if (!duplicatedAliases.isEmpty()) {
            throw new IllegalStateException("Could not determine appropriate instantiation strategy - no matching constructor found and arguments defined duplicated aliases [" + StringHelper.join(",", duplicatedAliases) + "] for bean-injection");
        }
        return new DynamicInstantiationAssemblerInjectionImpl<R>(this.javaTypeDescriptor, argumentReaders);
    }
}

