/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractJdbcValues
implements JdbcValues {
    private final QueryCachePutManager queryCachePutManager;

    public AbstractJdbcValues(QueryCachePutManager queryCachePutManager) {
        if (queryCachePutManager == null) {
            throw new IllegalArgumentException("QueryCachePutManager cannot be null");
        }
        this.queryCachePutManager = queryCachePutManager;
    }

    @Override
    public final boolean next(RowProcessingState rowProcessingState) throws SQLException {
        boolean hadRow = this.processNext(rowProcessingState);
        if (hadRow) {
            this.queryCachePutManager.registerJdbcRow(this.getCurrentRowValuesArray());
        }
        return hadRow;
    }

    protected abstract boolean processNext(RowProcessingState var1);

    @Override
    public final void finishUp(SharedSessionContractImplementor session) {
        this.queryCachePutManager.finishUp(session);
        this.release();
    }

    protected abstract void release();
}

