/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;
import org.jboss.logging.Logger;

public class DeferredResultSetAccess
extends AbstractResultSetAccess {
    private static final Logger log = CoreLogging.logger(DeferredResultSetAccess.class);
    private final JdbcSelect jdbcSelect;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final ExecutionContext executionContext;
    private final Function<String, PreparedStatement> statementCreator;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DeferredResultSetAccess(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator) {
        super(executionContext.getSession());
        this.jdbcParameterBindings = jdbcParameterBindings;
        this.executionContext = executionContext;
        this.jdbcSelect = jdbcSelect;
        this.statementCreator = statementCreator;
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.executionContext.getSession().getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        JdbcServices jdbcServices = this.getPersistenceContext().getFactory().getServiceRegistry().getService(JdbcServices.class);
        String sql = this.jdbcSelect.getSql();
        try {
            log.tracef("Executing query to retrieve ResultSet : %s", (Object)sql);
            this.preparedStatement = this.statementCreator.apply(sql);
            if (this.executionContext.getQueryOptions() != null) {
                if (this.executionContext.getQueryOptions().getFetchSize() != null) {
                    this.preparedStatement.setFetchSize(this.executionContext.getQueryOptions().getFetchSize());
                }
                if (this.executionContext.getQueryOptions().getTimeout() != null) {
                    this.preparedStatement.setQueryTimeout(this.executionContext.getQueryOptions().getTimeout());
                }
            }
            int paramBindingPosition = 1;
            for (JdbcParameterBinder parameterBinder : this.jdbcSelect.getParameterBinders()) {
                parameterBinder.bindParameterValue(this.preparedStatement, paramBindingPosition++, this.jdbcParameterBindings, this.executionContext);
            }
            this.executionContext.getSession().getEventListenerManager().jdbcExecuteStatementStart();
            try {
                this.resultSet = this.preparedStatement.executeQuery();
            }
            finally {
                this.executionContext.getSession().getEventListenerManager().jdbcExecuteStatementEnd();
            }
            logicalConnection.getResourceRegistry().register(this.resultSet, this.preparedStatement);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "JDBC exception executing SQL [" + sql + "]");
        }
        finally {
            logicalConnection.afterStatement();
        }
    }

    @Override
    public void release() {
        if (this.resultSet != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.resultSet, this.preparedStatement);
            this.resultSet = null;
        }
        if (this.preparedStatement != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.preparedStatement);
            this.preparedStatement = null;
        }
    }
}

