/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private static final Object[][] NO_DATA = new Object[0][];
    private Object[][] cachedData;
    private final int numberOfRows;
    private JdbcValuesMapping resolvedMapping;
    private int position = -1;

    public JdbcValuesCacheHit(Object[][] cachedData, JdbcValuesMapping resolvedMapping) {
        super(QueryCachePutManagerDisabledImpl.INSTANCE);
        this.cachedData = cachedData;
        this.numberOfRows = cachedData.length;
        this.resolvedMapping = resolvedMapping;
    }

    public JdbcValuesCacheHit(List<Object[]> cachedResults, JdbcValuesMapping resolvedMapping) {
        this(JdbcValuesCacheHit.extractData(cachedResults), resolvedMapping);
    }

    private static Object[][] extractData(List<Object[]> cachedResults) {
        if (CollectionHelper.isEmpty(cachedResults)) {
            return NO_DATA;
        }
        Object[][] data = new Object[cachedResults.size()][];
        for (int i = 0; i < cachedResults.size(); ++i) {
            Object[] row = cachedResults.get(i);
            data[i] = row;
        }
        return data;
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        ResultsLogger.LOGGER.tracef("JdbcValuesCacheHit#processNext : position = %i; numberOfRows = %i", this.position, this.numberOfRows);
        if (this.position >= this.numberOfRows - 1) {
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.resolvedMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        if (this.position >= this.numberOfRows) {
            return null;
        }
        return this.cachedData[this.position];
    }

    @Override
    protected void release() {
        this.cachedData = null;
    }
}

