/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    private static final ListResultsConsumer UNIQUE_FILTER_INSTANCE = new ListResultsConsumer(true);
    private static final ListResultsConsumer NORMAL_INSTANCE = new ListResultsConsumer(false);
    private final boolean uniqueFilter;

    public static <R> ListResultsConsumer<R> instance(boolean uniqueFilter) {
        return uniqueFilter ? UNIQUE_FILTER_INSTANCE : NORMAL_INSTANCE;
    }

    public ListResultsConsumer(boolean uniqueFilter) {
        this.uniqueFilter = uniqueFilter;
    }

    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        try {
            EntityPersister entityDescriptor;
            PersistenceContext persistenceContext = session.getPersistenceContext();
            persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
            boolean uniqueRows = false;
            Class<R> resultJavaType = rowReader.getResultJavaType();
            if (this.uniqueFilter && resultJavaType != null && !resultJavaType.isArray() && (entityDescriptor = session.getFactory().getMetamodel().findEntityDescriptor(resultJavaType)) != null) {
                uniqueRows = true;
            }
            ArrayList<R> results = new ArrayList<R>();
            while (rowProcessingState.next()) {
                R row = rowReader.readRow(rowProcessingState, processingOptions);
                boolean add = true;
                if (uniqueRows && results.contains(row)) {
                    add = false;
                }
                if (add) {
                    results.add(row);
                }
                rowProcessingState.finishRowProcessing();
            }
            persistenceContext.initializeNonLazyCollections();
            ArrayList<R> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Error processing return rows");
        }
        finally {
            rowReader.finishUp(jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp();
            jdbcValues.finishUp(session);
        }
    }
}

