/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardSequenceExporter
implements Exporter<Sequence> {
    private final Dialect dialect;

    public StandardSequenceExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Sequence sequence, Metadata metadata) {
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        return this.dialect.getSequenceSupport().getCreateSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getName(), jdbcEnvironment.getDialect()), sequence.getInitialValue(), sequence.getIncrementSize());
    }

    @Override
    public String[] getSqlDropStrings(Sequence sequence, Metadata metadata) {
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        return this.dialect.getSequenceSupport().getDropSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getName(), jdbcEnvironment.getDialect()));
    }
}

