/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.grammars.importsql.SqlScriptParser;
import org.hibernate.grammars.importsql.SqlScriptParserBaseVisitor;

public class SqlScriptVisitor
extends SqlScriptParserBaseVisitor<Object> {
    private final Dialect dialect;

    public SqlScriptVisitor(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public ArrayList<String> visitScript(SqlScriptParser.ScriptContext ctx) {
        ArrayList<String> commands = new ArrayList<String>();
        for (int i = 0; i < ctx.commandBlock().size(); ++i) {
            commands.add(this.visitCommandBlock(ctx.commandBlock().get(i)));
        }
        return commands;
    }

    @Override
    public String visitCommandBlock(SqlScriptParser.CommandBlockContext ctx) {
        return this.visitCommand(ctx.command());
    }

    @Override
    public String visitCommand(SqlScriptParser.CommandContext ctx) {
        List<SqlScriptParser.CommandPartContext> commandParts = ctx.commandPart();
        StringBuilder commandBuffer = new StringBuilder();
        String separator = "";
        for (int i = 0; i < commandParts.size(); ++i) {
            commandBuffer.append(separator);
            SqlScriptParser.CommandPartContext commandPart = commandParts.get(i);
            if (commandPart.notStmtEnd() != null) {
                commandBuffer.append(commandPart.notStmtEnd().getText());
            } else if (commandPart.quotedText() != null) {
                commandBuffer.append(this.visitQuotedText(commandPart.quotedText()));
            }
            separator = " ";
        }
        return commandBuffer.toString();
    }

    @Override
    public Object visitQuotedText(SqlScriptParser.QuotedTextContext ctx) {
        return this.dialect.quote(ctx.QUOTED_TEXT().getText());
    }
}

