/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.LocalDateTime;
import java.util.Comparator;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.LocalDateType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.LocalDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateTimeType
extends AbstractSingleColumnStandardBasicType<LocalDateTime>
implements VersionType<LocalDateTime>,
LiteralType<LocalDateTime>,
AllowableTemporalParameterType<LocalDateTime> {
    public static final LocalDateTimeType INSTANCE = new LocalDateTimeType();

    public LocalDateTimeType() {
        super(TimestampTypeDescriptor.INSTANCE, LocalDateTimeJavaDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return LocalDateTime.class.getSimpleName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public LocalDateTime seed(SharedSessionContractImplementor session) {
        return LocalDateTime.now();
    }

    @Override
    public LocalDateTime next(LocalDateTime current, SharedSessionContractImplementor session) {
        return LocalDateTime.now();
    }

    @Override
    public Comparator<LocalDateTime> getComparator() {
        return ComparableComparator.INSTANCE;
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
            case DATE: {
                return LocalDateType.INSTANCE;
            }
        }
        throw new QueryException("LocalDateTime type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

