/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.OffsetDateTime;
import java.util.Comparator;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.DateType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.OffsetTimeType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.TimestampWithTimeZoneDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetDateTimeType
extends AbstractSingleColumnStandardBasicType<OffsetDateTime>
implements VersionType<OffsetDateTime>,
LiteralType<OffsetDateTime>,
AllowableTemporalParameterType<OffsetDateTime> {
    public static final OffsetDateTimeType INSTANCE = new OffsetDateTimeType();

    public OffsetDateTimeType() {
        super(TimestampWithTimeZoneDescriptor.INSTANCE, OffsetDateTimeJavaDescriptor.INSTANCE);
    }

    @Override
    public OffsetDateTime seed(SharedSessionContractImplementor session) {
        return OffsetDateTime.now();
    }

    @Override
    public OffsetDateTime next(OffsetDateTime current, SharedSessionContractImplementor session) {
        return OffsetDateTime.now();
    }

    @Override
    public Comparator<OffsetDateTime> getComparator() {
        return OffsetDateTime.timeLineOrder();
    }

    @Override
    public String getName() {
        return OffsetDateTime.class.getSimpleName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
            case TIME: {
                return OffsetTimeType.INSTANCE;
            }
            case DATE: {
                return DateType.INSTANCE;
            }
        }
        throw new QueryException("OffsetDateTime type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

