/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.ZonedDateTime;
import java.util.Comparator;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ZonedDateTimeComparator;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.ZonedDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.TimestampWithTimeZoneDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class ZonedDateTimeType
extends AbstractSingleColumnStandardBasicType<ZonedDateTime>
implements VersionType<ZonedDateTime>,
LiteralType<ZonedDateTime>,
AllowableTemporalParameterType<ZonedDateTime> {
    public static final ZonedDateTimeType INSTANCE = new ZonedDateTimeType();

    public ZonedDateTimeType() {
        super(TimestampWithTimeZoneDescriptor.INSTANCE, ZonedDateTimeJavaDescriptor.INSTANCE);
    }

    @Override
    public ZonedDateTime seed(SharedSessionContractImplementor session) {
        return ZonedDateTime.now();
    }

    @Override
    public ZonedDateTime next(ZonedDateTime current, SharedSessionContractImplementor session) {
        return ZonedDateTime.now();
    }

    @Override
    public Comparator<ZonedDateTime> getComparator() {
        return ZonedDateTimeComparator.INSTANCE;
    }

    @Override
    public String getName() {
        return ZonedDateTime.class.getSimpleName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
        }
        throw new QueryException("ZonedDateTime type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

