/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.compare.CalendarComparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarDateTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.DateTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarTypeDescriptor
extends AbstractTemporalTypeDescriptor<Calendar> {
    public static final CalendarTypeDescriptor INSTANCE = new CalendarTypeDescriptor();

    protected CalendarTypeDescriptor() {
        super(Calendar.class, CalendarMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return TimeTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return CalendarDateTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return CalendarTimeTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(Calendar value) {
        return DateTypeDescriptor.INSTANCE.toString(value.getTime());
    }

    @Override
    public Calendar fromString(String string) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(DateTypeDescriptor.INSTANCE.fromString(string));
        return result;
    }

    @Override
    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(14) == another.get(14) && one.get(13) == another.get(13) && one.get(12) == another.get(12) && one.get(11) == another.get(11) && one.get(5) == another.get(5) && one.get(2) == another.get(2) && one.get(1) == another.get(1);
    }

    @Override
    public int extractHashCode(Calendar value) {
        int hashCode = 1;
        hashCode = 31 * hashCode + value.get(14);
        hashCode = 31 * hashCode + value.get(13);
        hashCode = 31 * hashCode + value.get(12);
        hashCode = 31 * hashCode + value.get(11);
        hashCode = 31 * hashCode + value.get(5);
        hashCode = 31 * hashCode + value.get(2);
        hashCode = 31 * hashCode + value.get(1);
        return hashCode;
    }

    @Override
    public Comparator<Calendar> getComparator() {
        return CalendarComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(Calendar value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)new Date(value.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)new Time(value.getTimeInMillis());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)new Timestamp(value.getTimeInMillis());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)new java.util.Date(value.getTimeInMillis());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Calendar wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isInstance(value)) {
            return (Calendar)value;
        }
        if (!java.util.Date.class.isInstance(value)) {
            throw this.unknownWrap(value.getClass());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime((java.util.Date)value);
        return cal;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }

    public static class CalendarMutabilityPlan
    extends MutableMutabilityPlan<Calendar> {
        public static final CalendarMutabilityPlan INSTANCE = new CalendarMutabilityPlan();

        @Override
        public Calendar deepCopyNotNull(Calendar value) {
            return (Calendar)value.clone();
        }
    }
}

