/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InstantJavaDescriptor
extends AbstractTemporalTypeDescriptor<Instant> {
    public static final InstantJavaDescriptor INSTANCE = new InstantJavaDescriptor();

    public InstantJavaDescriptor() {
        super(Instant.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return JdbcDateTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimeTypeDescriptor.INSTANCE;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return TimestampTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(Instant value) {
        return DateTimeFormatter.ISO_INSTANT.format(value);
    }

    @Override
    public Instant fromString(String string) {
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(string));
    }

    @Override
    public <X> X unwrap(Instant instant, Class<X> type, WrapperOptions options) {
        if (instant == null) {
            return null;
        }
        if (Instant.class.isAssignableFrom(type)) {
            return (X)instant;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            ZoneId zoneId = ZoneId.ofOffset("UTC", ZoneOffset.UTC);
            return (X)GregorianCalendar.from(instant.atZone(zoneId));
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
            if (zonedDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(zonedDateTime.toLocalDateTime());
            }
            return (X)Timestamp.from(instant);
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(instant);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(instant);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Instant wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant();
            }
            return ts.toInstant();
        }
        if (value instanceof Long) {
            return Instant.ofEpochMilli((Long)value);
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toInstant();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }
}

