/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcTimestampTypeDescriptor
extends AbstractTemporalTypeDescriptor<java.util.Date> {
    public static final JdbcTimestampTypeDescriptor INSTANCE = new JdbcTimestampTypeDescriptor();
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final DateTimeFormatter LOGGABLE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public JdbcTimestampTypeDescriptor() {
        super(java.util.Date.class, TimestampMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return TimestampTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(java.util.Date value) {
        return LOGGABLE_FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(String string) {
        try {
            return new Timestamp(new SimpleDateFormat(TIMESTAMP_FORMAT).parse(string).getTime());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse timestamp string" + string, pe);
        }
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        int n2;
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        long t1 = one.getTime();
        long t2 = another.getTime();
        boolean oneIsTimestamp = one instanceof Timestamp;
        boolean anotherIsTimestamp = another instanceof Timestamp;
        int n1 = oneIsTimestamp ? ((Timestamp)one).getNanos() : 0;
        int n = n2 = anotherIsTimestamp ? ((Timestamp)another).getNanos() : 0;
        if (t1 != t2) {
            return false;
        }
        if (oneIsTimestamp && anotherIsTimestamp) {
            int nn1 = n1 % 1000000;
            int nn2 = n2 % 1000000;
            return nn1 == nn2;
        }
        return true;
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        return Long.valueOf(value.getTime() / 1000L).hashCode();
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = value instanceof Timestamp ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = value instanceof Date ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = value instanceof Time ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }

    public static class TimestampMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final TimestampMutabilityPlan INSTANCE = new TimestampMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            if (value instanceof Timestamp) {
                Timestamp orig = (Timestamp)value;
                Timestamp ts = new Timestamp(orig.getTime());
                ts.setNanos(orig.getNanos());
                return ts;
            }
            return new java.util.Date(value.getTime());
        }
    }
}

