/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.SerializableTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.DynamicModelJtd;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBaseline;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBasicAdaptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeDescriptorRegistry
implements JavaTypeDescriptorBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JavaTypeDescriptorRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private ConcurrentHashMap<Class, JavaTypeDescriptor> descriptorsByClass = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(JavaTypeDescriptor descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaTypeDescriptor with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Class describedJavaType, JavaTypeDescriptor descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByClass.put(describedJavaType, descriptor);
    }

    private void performInjections(JavaTypeDescriptor descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)descriptor)).setTypeConfiguration(this.typeConfiguration);
        }
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Class<T> javaType) {
        return this.resolveDescriptor(javaType);
    }

    public void addDescriptor(JavaTypeDescriptor descriptor) {
        JavaTypeDescriptor old = this.descriptorsByClass.put(descriptor.getJavaType(), descriptor);
        if (old != null) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", descriptor.getJavaType(), (Object)descriptor, (Object)old);
        }
        this.performInjections(descriptor);
    }

    public <J> JavaTypeDescriptor<J> resolveDescriptor(Class<J> javaType, Supplier<JavaTypeDescriptor<J>> creator) {
        JavaTypeDescriptor cached = this.descriptorsByClass.get(javaType);
        if (cached != null) {
            return cached;
        }
        JavaTypeDescriptor<J> created = creator.get();
        this.descriptorsByClass.put(javaType, created);
        return created;
    }

    public <J> JavaTypeDescriptor<J> resolveDescriptor(Class<J> javaType) {
        return this.resolveDescriptor(javaType, () -> {
            AbstractTypeDescriptor fallbackDescriptor = javaType.isEnum() ? new EnumJavaTypeDescriptor(javaType) : (Serializable.class.isAssignableFrom(javaType) ? new SerializableTypeDescriptor(javaType) : new JavaTypeDescriptorBasicAdaptor(javaType));
            return fallbackDescriptor;
        });
    }

    public JavaTypeDescriptor<?> resolveDynamicEntityDescriptor(String typeName) {
        return new DynamicModelJtd();
    }
}

