/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import java.sql.Time;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterTemporal
extends BasicJdbcLiteralFormatter {
    private final TemporalType precision;

    public JdbcLiteralFormatterTemporal(JavaTypeDescriptor javaTypeDescriptor, TemporalType precision) {
        super(javaTypeDescriptor);
        this.precision = precision;
    }

    public String toJdbcLiteral(Object value, Dialect dialect, SharedSessionContractImplementor session) {
        if (value instanceof Date) {
            return dialect.formatDateTimeLiteral((Date)value, this.precision);
        }
        if (value instanceof Calendar) {
            return dialect.formatDateTimeLiteral((Calendar)value, this.precision);
        }
        if (value instanceof TemporalAccessor) {
            return dialect.formatDateTimeLiteral((TemporalAccessor)value, this.precision);
        }
        switch (this.precision) {
            case DATE: {
                return dialect.formatDateTimeLiteral(this.unwrap(value, java.sql.Date.class, session), this.precision);
            }
            case TIME: {
                return dialect.formatDateTimeLiteral(this.unwrap(value, Time.class, session), this.precision);
            }
        }
        return dialect.formatDateTimeLiteral(this.unwrap(value, Date.class, session), this.precision);
    }
}

