/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedBasicTypeResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaTypeDescriptor<J> domainJtd;
    private final BasicType basicType;
    private final BasicValueConverter valueConverter;
    private final MutabilityPlan<J> mutabilityPlan;

    public NamedBasicTypeResolution(JavaTypeDescriptor<J> domainJtd, BasicType basicType, BasicValueConverter valueConverter, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, MetadataBuildingContext context) {
        this.domainJtd = domainJtd;
        this.basicType = basicType;
        this.valueConverter = null;
        MutabilityPlan<J> explicitPlan = explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(context.getBootstrapContext().getTypeConfiguration()) : null;
        this.mutabilityPlan = explicitPlan != null ? explicitPlan : domainJtd.getMutabilityPlan();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.basicType;
    }

    @Override
    public BasicType getLegacyResolvedBasicType() {
        return this.basicType;
    }

    @Override
    public JavaTypeDescriptor<J> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
        return this.basicType.getJavaTypeDescriptor();
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.basicType.getSqlTypeDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }
}

