/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.boot.BootLogging;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryPropertyReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmResultSetMappingType;
import org.hibernate.boot.query.BootQueryLogging;
import org.hibernate.boot.query.FetchDescriptor;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.query.ResultDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.FetchMementoBasicStandard;
import org.hibernate.query.internal.FetchMementoHbmStandard;
import org.hibernate.query.internal.ModelPartResultMementoBasicImpl;
import org.hibernate.query.internal.NamedResultSetMappingMementoImpl;
import org.hibernate.query.internal.ResultMementoBasicStandard;
import org.hibernate.query.internal.ResultMementoCollectionStandard;
import org.hibernate.query.internal.ResultMementoEntityStandard;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.named.ResultMemento;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.type.BasicType;

public class HbmResultSetMappingDescriptor
implements NamedResultSetMappingDescriptor {
    private final String registrationName;
    private final List<ResultDescriptor> resultDescriptors;
    private final Map<String, Map<String, JoinDescriptor>> joinDescriptors;
    private final Map<String, HbmFetchParent> fetchParentByAlias;

    public HbmResultSetMappingDescriptor(JaxbHbmResultSetMappingType hbmResultSetMapping, MetadataBuildingContext context) {
        this.registrationName = hbmResultSetMapping.getName();
        BootLogging.LOGGER.debugf("Creating explicit HbmResultSetMappingDescriptor : %s", (Object)this.registrationName);
        List<Serializable> hbmValueMappingsSource = hbmResultSetMapping.getValueMappingSources();
        ArrayList localResultDescriptors = CollectionHelper.arrayList(hbmValueMappingsSource.size());
        this.joinDescriptors = new HashMap<String, Map<String, JoinDescriptor>>();
        this.fetchParentByAlias = new HashMap<String, HbmFetchParent>();
        boolean foundCollectionReturn = false;
        for (int i = 0; i < hbmValueMappingsSource.size(); ++i) {
            Serializable hbmValueMapping = hbmValueMappingsSource.get(i);
            if (hbmValueMapping == null) {
                throw new IllegalStateException("ValueMappingSources contained null reference(s)");
            }
            if (hbmValueMapping instanceof JaxbHbmNativeQueryReturnType) {
                JaxbHbmNativeQueryReturnType hbmEntityReturn = (JaxbHbmNativeQueryReturnType)hbmValueMapping;
                EntityResultDescriptor entityResultDescriptor = new EntityResultDescriptor(hbmEntityReturn, () -> this.joinDescriptors, this.registrationName, context);
                localResultDescriptors.add(entityResultDescriptor);
                this.fetchParentByAlias.put(entityResultDescriptor.tableAlias, entityResultDescriptor);
                continue;
            }
            if (hbmValueMapping instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                JaxbHbmNativeQueryCollectionLoadReturnType hbmCollectionReturn = (JaxbHbmNativeQueryCollectionLoadReturnType)hbmValueMapping;
                foundCollectionReturn = true;
                CollectionResultDescriptor collectionResultDescriptor = new CollectionResultDescriptor(hbmCollectionReturn, () -> this.joinDescriptors, this.registrationName, context);
                localResultDescriptors.add(collectionResultDescriptor);
                this.fetchParentByAlias.put(collectionResultDescriptor.tableAlias, collectionResultDescriptor);
                continue;
            }
            if (hbmValueMapping instanceof JaxbHbmNativeQueryJoinReturnType) {
                JaxbHbmNativeQueryJoinReturnType jaxbHbmJoinReturn = (JaxbHbmNativeQueryJoinReturnType)hbmValueMapping;
                HbmResultSetMappingDescriptor.collectJoinFetch(jaxbHbmJoinReturn, this.joinDescriptors, this.fetchParentByAlias, this.registrationName, context);
                continue;
            }
            if (hbmValueMapping instanceof JaxbHbmNativeQueryScalarReturnType) {
                JaxbHbmNativeQueryScalarReturnType hbmScalarReturn = (JaxbHbmNativeQueryScalarReturnType)hbmValueMapping;
                localResultDescriptors.add(new ScalarDescriptor(hbmScalarReturn));
                continue;
            }
            throw new IllegalArgumentException("Unknown NativeQueryReturn type : " + hbmValueMapping.getClass().getName());
        }
        if (foundCollectionReturn && localResultDescriptors.size() > 1) {
            throw new MappingException("Cannot combine other returns with a collection return (" + this.registrationName + ")");
        }
        this.resultDescriptors = localResultDescriptors;
    }

    public static void collectJoinFetch(JaxbHbmNativeQueryJoinReturnType jaxbHbmJoin, Map<String, Map<String, JoinDescriptor>> joinDescriptors, Map<String, HbmFetchParent> fetchParentByAlias, String registrationName, MetadataBuildingContext context) {
        JoinDescriptor existing;
        String fullPropertyPath = jaxbHbmJoin.getProperty();
        int firstDot = fullPropertyPath.indexOf(46);
        if (firstDot < 1) {
            throw new MappingException("Illegal <return-join/> property attribute: `" + fullPropertyPath + "`.  Shouldbe in the form `{ownerAlias.joinedPropertyPath}` (" + registrationName + ")");
        }
        String ownerTableAlias = fullPropertyPath.substring(0, firstDot - 1);
        String propertyPath = fullPropertyPath.substring(firstDot + 1);
        String tableAlias = jaxbHbmJoin.getAlias();
        Map<String, JoinDescriptor> joinDescriptorsForAlias = joinDescriptors.get(ownerTableAlias);
        if (joinDescriptorsForAlias == null) {
            joinDescriptorsForAlias = new HashMap<String, JoinDescriptor>();
            joinDescriptors.put(ownerTableAlias, joinDescriptorsForAlias);
        }
        if ((existing = joinDescriptorsForAlias.get(propertyPath)) != null) {
            throw new MappingException("Property join specified twice for join-return `" + ownerTableAlias + "." + propertyPath + "` (" + registrationName + ")");
        }
        JoinDescriptor joinDescriptor = new JoinDescriptor(jaxbHbmJoin, () -> joinDescriptors, () -> fetchParentByAlias, registrationName, context);
        joinDescriptorsForAlias.put(propertyPath, joinDescriptor);
        fetchParentByAlias.put(tableAlias, joinDescriptor);
    }

    public HbmResultSetMappingDescriptor(String registrationName, List<ResultDescriptor> resultDescriptors, Map<String, Map<String, JoinDescriptor>> joinDescriptors, Map<String, HbmFetchParent> fetchParentsByAlias) {
        this.registrationName = registrationName;
        this.resultDescriptors = resultDescriptors;
        this.joinDescriptors = joinDescriptors;
        assert (fetchParentsByAlias != null);
        assert (joinDescriptors != null);
        this.fetchParentByAlias = fetchParentsByAlias;
    }

    @Override
    public String getRegistrationName() {
        return this.registrationName;
    }

    @Override
    public NamedResultSetMappingMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
        BootQueryLogging.LOGGER.debugf("Resolving HbmResultSetMappingDescriptor into memento for [%s]", (Object)this.registrationName);
        ArrayList<ResultMemento> resultMementos = new ArrayList<ResultMemento>(this.resultDescriptors.size());
        this.resultDescriptors.forEach(descriptor -> resultMementos.add(descriptor.resolve(resolutionContext)));
        return new NamedResultSetMappingMementoImpl(this.registrationName, resultMementos);
    }

    public static List<HbmFetchDescriptor> extractPropertyFetchDescriptors(List<JaxbHbmNativeQueryPropertyReturnType> hbmReturnProperties, HbmFetchParent fetchParent, String registrationName, MetadataBuildingContext context) {
        ArrayList<HbmFetchDescriptor> propertyFetchDescriptors = new ArrayList<HbmFetchDescriptor>(hbmReturnProperties.size());
        hbmReturnProperties.forEach(propertyReturn -> propertyFetchDescriptors.add(new PropertyFetchDescriptor((JaxbHbmNativeQueryPropertyReturnType)propertyReturn, fetchParent, registrationName, context)));
        return propertyFetchDescriptors;
    }

    public static void applyFetchJoins(Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess, String tableAlias, List<HbmFetchDescriptor> propertyFetchDescriptors) {
        Map<String, Map<String, JoinDescriptor>> joinDescriptors = joinDescriptorsAccess.get();
        if (joinDescriptors == null) {
            return;
        }
        Map<String, JoinDescriptor> ownerJoinDescriptors = joinDescriptors.get(tableAlias);
        if (ownerJoinDescriptors != null) {
            HashSet processedFetchableNames = new HashSet();
            ownerJoinDescriptors.forEach((fetchableName, joinDescriptor) -> {
                boolean added = processedFetchableNames.add(fetchableName);
                if (!added) {
                    for (int i = 0; i < propertyFetchDescriptors.size(); ++i) {
                        HbmFetchDescriptor propertyFetchDescriptor = (HbmFetchDescriptor)propertyFetchDescriptors.get(i);
                        if (!propertyFetchDescriptor.getFetchablePath().equals(fetchableName)) continue;
                        propertyFetchDescriptors.set(i, (HbmFetchDescriptor)joinDescriptor);
                    }
                }
            });
        }
    }

    public static class ScalarDescriptor
    implements ResultDescriptor {
        private final String columnName;
        private final String hibernateTypeName;

        public ScalarDescriptor(String columnName, String hibernateTypeName) {
            this.columnName = columnName;
            this.hibernateTypeName = hibernateTypeName;
            BootQueryLogging.LOGGER.debugf("Creating ScalarDescriptor (%s)", (Object)columnName);
        }

        public ScalarDescriptor(JaxbHbmNativeQueryScalarReturnType hbmScalarReturn) {
            this(hbmScalarReturn.getColumn(), hbmScalarReturn.getType());
        }

        @Override
        public ResultMementoBasicStandard resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.LOGGER.debugf("Resolving HBM ScalarDescriptor into memento - %s", (Object)this.columnName);
            if (this.hibernateTypeName != null) {
                BasicType namedType = resolutionContext.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.hibernateTypeName);
                if (namedType == null) {
                    throw new IllegalArgumentException("Could not resolve named type : " + this.hibernateTypeName);
                }
                return new ResultMementoBasicStandard(this.columnName, namedType, resolutionContext);
            }
            return new ResultMementoBasicStandard(this.columnName, null, resolutionContext);
        }
    }

    public static class CollectionResultDescriptor
    implements ResultDescriptor,
    HbmFetchParent {
        private final NavigablePath collectionPath;
        private final String tableAlias;
        private final LockMode lockMode;
        private final Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess;
        private final List<HbmFetchDescriptor> propertyFetchDescriptors;
        private ResultMemento memento;
        private FetchMementoHbmStandard.FetchParentMemento thisAsParentMemento;

        public CollectionResultDescriptor(JaxbHbmNativeQueryCollectionLoadReturnType hbmCollectionReturn, Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess, String registrationName, MetadataBuildingContext context) {
            this.collectionPath = new NavigablePath(hbmCollectionReturn.getRole());
            this.tableAlias = hbmCollectionReturn.getAlias();
            if (this.tableAlias == null) {
                throw new MappingException("<return-collection/> did not specify alias [" + this.collectionPath.getFullPath() + "]");
            }
            BootQueryLogging.LOGGER.debugf("Creating CollectionResultDescriptor (%s : %s)", (Object)this.tableAlias, (Object)this.collectionPath);
            this.lockMode = hbmCollectionReturn.getLockMode();
            this.joinDescriptorsAccess = joinDescriptorsAccess;
            this.propertyFetchDescriptors = HbmResultSetMappingDescriptor.extractPropertyFetchDescriptors(hbmCollectionReturn.getReturnProperty(), this, registrationName, context);
        }

        @Override
        public ResultMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.LOGGER.debugf("Resolving HBM CollectionResultDescriptor into memento - %s : %s", (Object)this.tableAlias, (Object)this.collectionPath);
            if (this.memento == null) {
                HbmResultSetMappingDescriptor.applyFetchJoins(this.joinDescriptorsAccess, this.tableAlias, this.propertyFetchDescriptors);
                FetchMementoHbmStandard.FetchParentMemento thisAsParentMemento = this.resolveParentMemento(resolutionContext);
                this.memento = new ResultMementoCollectionStandard(thisAsParentMemento.getNavigablePath(), (PluralAttributeMapping)thisAsParentMemento.getFetchableContainer());
            }
            return this.memento;
        }

        @Override
        public FetchMementoHbmStandard.FetchParentMemento resolveParentMemento(ResultSetMappingResolutionContext resolutionContext) {
            if (this.thisAsParentMemento == null) {
                CollectionPersister collectionDescriptor = resolutionContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.collectionPath.getFullPath());
                this.thisAsParentMemento = new HbmFetchParentMemento(this.collectionPath, collectionDescriptor.getAttributeMapping());
            }
            return this.thisAsParentMemento;
        }
    }

    public static class JoinDescriptor
    implements HbmFetchDescriptor,
    HbmFetchParent {
        private final String ownerTableAlias;
        private final String tableAlias;
        private final String propertyPath;
        private final LockMode lockMode;
        private final List<HbmFetchDescriptor> propertyFetchDescriptors;
        private final Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess;
        private final Supplier<Map<String, HbmFetchParent>> fetchParentByAliasAccess;
        private FetchMementoHbmStandard memento;
        private HbmFetchParentMemento thisAsParentMemento;

        public JoinDescriptor(JaxbHbmNativeQueryJoinReturnType hbmJoinReturn, Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess, Supplier<Map<String, HbmFetchParent>> fetchParentByAliasAccess, String registrationName, MetadataBuildingContext context) {
            this.joinDescriptorsAccess = joinDescriptorsAccess;
            this.fetchParentByAliasAccess = fetchParentByAliasAccess;
            String fullPropertyPath = hbmJoinReturn.getProperty();
            int firstDot = fullPropertyPath.indexOf(46);
            if (firstDot < 1) {
                throw new MappingException("Illegal <return-join/> property attribute: `" + fullPropertyPath + "`.  Shouldbe in the form `{ownerAlias.joinedPropertyPath}`");
            }
            this.ownerTableAlias = fullPropertyPath.substring(0, firstDot - 1);
            this.propertyPath = fullPropertyPath.substring(firstDot + 1);
            this.tableAlias = hbmJoinReturn.getAlias();
            if (this.tableAlias == null) {
                throw new MappingException("<return-join/> did not specify alias [" + this.ownerTableAlias + "." + this.propertyPath + "]");
            }
            this.lockMode = hbmJoinReturn.getLockMode();
            this.propertyFetchDescriptors = HbmResultSetMappingDescriptor.extractPropertyFetchDescriptors(hbmJoinReturn.getReturnProperty(), this, registrationName, context);
        }

        @Override
        public String getFetchablePath() {
            return this.propertyPath;
        }

        @Override
        public FetchMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.LOGGER.debugf("Resolving HBM JoinDescriptor into memento - %s : %s . %s", (Object)this.tableAlias, (Object)this.ownerTableAlias, (Object)this.propertyPath);
            if (this.memento == null) {
                HbmFetchParentMemento thisAsParentMemento = this.resolveParentMemento(resolutionContext);
                HbmResultSetMappingDescriptor.applyFetchJoins(this.joinDescriptorsAccess, this.tableAlias, this.propertyFetchDescriptors);
                this.memento = new FetchMementoHbmStandard(thisAsParentMemento.getNavigablePath(), thisAsParentMemento, (Fetchable)((Object)thisAsParentMemento.getFetchableContainer()));
            }
            return this.memento;
        }

        @Override
        public HbmFetchParentMemento resolveParentMemento(ResultSetMappingResolutionContext resolutionContext) {
            if (this.thisAsParentMemento == null) {
                HbmFetchParent hbmFetchParent = this.fetchParentByAliasAccess.get().get(this.ownerTableAlias);
                if (hbmFetchParent == null) {
                    throw new MappingException("Could not locate join-return owner by alias [" + this.ownerTableAlias + "] for join path [" + this.propertyPath + "]");
                }
                FetchMementoHbmStandard.FetchParentMemento ownerMemento = hbmFetchParent.resolveParentMemento(resolutionContext);
                String[] parts = this.propertyPath.split("\\.");
                NavigablePath navigablePath = ownerMemento.getNavigablePath().append(parts[0]);
                FetchableContainer fetchable = (FetchableContainer)ownerMemento.getFetchableContainer().findSubPart(parts[0], null);
                for (int i = 1; i < parts.length; ++i) {
                    navigablePath = navigablePath.append(parts[i]);
                    fetchable = (FetchableContainer)fetchable.findSubPart(parts[i], null);
                }
                this.thisAsParentMemento = new HbmFetchParentMemento(navigablePath, fetchable);
            }
            return this.thisAsParentMemento;
        }

        @Override
        public ResultMemento asResultMemento(NavigablePath path, ResultSetMappingResolutionContext resolutionContext) {
            throw new UnsupportedOperationException();
        }
    }

    public static class PropertyFetchDescriptor
    implements HbmFetchDescriptor {
        private final HbmFetchParent parent;
        private final String propertyPath;
        private final String[] propertyPathParts;
        private final List<String> columnAliases;

        public PropertyFetchDescriptor(JaxbHbmNativeQueryPropertyReturnType hbmPropertyMapping, HbmFetchParent parent, String registrationName, MetadataBuildingContext context) {
            this.parent = parent;
            this.propertyPath = hbmPropertyMapping.getName();
            this.propertyPathParts = this.propertyPath.split("\\.");
            this.columnAliases = PropertyFetchDescriptor.extractColumnAliases(hbmPropertyMapping, context);
            BootQueryLogging.LOGGER.debugf("Creating PropertyFetchDescriptor (%s : %s) for ResultSet mapping - %s", (Object)parent, (Object)this.propertyPath, (Object)registrationName);
        }

        @Override
        public String getFetchablePath() {
            return this.propertyPath;
        }

        private static List<String> extractColumnAliases(JaxbHbmNativeQueryPropertyReturnType hbmPropertyMapping, MetadataBuildingContext context) {
            if (hbmPropertyMapping.getColumn() != null) {
                return Collections.singletonList(hbmPropertyMapping.getColumn());
            }
            ArrayList<String> columnAliases = new ArrayList<String>(hbmPropertyMapping.getReturnColumn().size());
            hbmPropertyMapping.getReturnColumn().forEach(column -> columnAliases.add(column.getName()));
            return columnAliases;
        }

        @Override
        public FetchMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.LOGGER.debugf("Resolving HBM PropertyFetchDescriptor into memento - %s : %s", (Object)this.parent, (Object)this.propertyPath);
            FetchMementoHbmStandard.FetchParentMemento fetchParentMemento = this.parent.resolveParentMemento(resolutionContext);
            NavigablePath navigablePath = fetchParentMemento.getNavigablePath().append(this.propertyPathParts[0]);
            Fetchable fetchable = (Fetchable)fetchParentMemento.getFetchableContainer().findSubPart(this.propertyPathParts[0], null);
            for (int i = 1; i < this.propertyPathParts.length; ++i) {
                if (!(fetchable instanceof FetchableContainer)) {
                    throw new MappingException("Non-terminal property path [" + navigablePath.getFullPath() + " did not reference FetchableContainer");
                }
                navigablePath = fetchParentMemento.getNavigablePath().append(this.propertyPathParts[i]);
                fetchable = (Fetchable)((FetchableContainer)((Object)fetchable)).findSubPart(this.propertyPathParts[i], null);
            }
            return new FetchMementoBasicStandard(navigablePath, (BasicValuedModelPart)fetchable, this.columnAliases.get(0));
        }

        @Override
        public ResultMemento asResultMemento(NavigablePath path, ResultSetMappingResolutionContext resolutionContext) {
            throw new UnsupportedOperationException("PropertyFetchDescriptor cannot be converted to a result");
        }
    }

    public static class EntityResultDescriptor
    implements ResultDescriptor,
    HbmFetchParent {
        private final String entityName;
        private final String tableAlias;
        private final String discriminatorColumnAlias;
        private final LockMode lockMode;
        private final List<HbmFetchDescriptor> propertyFetchDescriptors;
        private final Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess;
        private final String registrationName;
        private HbmFetchParentMemento thisAsParentMemento;

        public EntityResultDescriptor(JaxbHbmNativeQueryReturnType hbmEntityReturn, Supplier<Map<String, Map<String, JoinDescriptor>>> joinDescriptorsAccess, String registrationName, MetadataBuildingContext context) {
            assert (joinDescriptorsAccess != null);
            String string = this.entityName = hbmEntityReturn.getEntityName() != null ? hbmEntityReturn.getEntityName() : hbmEntityReturn.getClazz();
            if (this.entityName == null) {
                throw new MappingException("Entity <return/> mapping did not specify entity name");
            }
            this.tableAlias = hbmEntityReturn.getAlias();
            if (this.tableAlias == null) {
                throw new MappingException("Entity <return/> mapping did not specify alias");
            }
            BootQueryLogging.LOGGER.debugf("Creating EntityResultDescriptor (%s : %s) for ResultSet mapping - %s", (Object)this.tableAlias, (Object)this.entityName, (Object)registrationName);
            this.discriminatorColumnAlias = hbmEntityReturn.getClazz();
            this.lockMode = hbmEntityReturn.getLockMode();
            this.joinDescriptorsAccess = joinDescriptorsAccess;
            this.registrationName = registrationName;
            this.propertyFetchDescriptors = HbmResultSetMappingDescriptor.extractPropertyFetchDescriptors(hbmEntityReturn.getReturnProperty(), this, registrationName, context);
        }

        @Override
        public ResultMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            ModelPartResultMementoBasicImpl discriminatorMemento;
            BootQueryLogging.LOGGER.debugf("Resolving HBM EntityResultDescriptor into memento - %s : %s (%s)", (Object)this.tableAlias, (Object)this.entityName, (Object)this.registrationName);
            EntityMappingType entityDescriptor = resolutionContext.getSessionFactory().getRuntimeMetamodels().getEntityMappingType(this.entityName);
            HbmResultSetMappingDescriptor.applyFetchJoins(this.joinDescriptorsAccess, this.tableAlias, this.propertyFetchDescriptors);
            NavigablePath entityPath = new NavigablePath(this.entityName);
            if (this.discriminatorColumnAlias == null) {
                discriminatorMemento = null;
            } else {
                if (entityDescriptor.getDiscriminatorMapping() == null) {
                    throw new MappingException("Discriminator column mapping given for non-discriminated entity [" + this.entityName + "] as part of resultset mapping [" + this.registrationName + "]");
                }
                discriminatorMemento = new ModelPartResultMementoBasicImpl(entityPath.append("{discriminator}"), entityDescriptor.getDiscriminatorMapping(), this.discriminatorColumnAlias);
            }
            HashMap<String, FetchMemento> fetchDescriptorMap = new HashMap<String, FetchMemento>();
            this.propertyFetchDescriptors.forEach(hbmFetchDescriptor -> fetchDescriptorMap.put(hbmFetchDescriptor.getFetchablePath(), hbmFetchDescriptor.resolve(resolutionContext)));
            return new ResultMementoEntityStandard(entityDescriptor, this.lockMode, discriminatorMemento, fetchDescriptorMap);
        }

        @Override
        public FetchMementoHbmStandard.FetchParentMemento resolveParentMemento(ResultSetMappingResolutionContext resolutionContext) {
            if (this.thisAsParentMemento == null) {
                EntityMappingType entityDescriptor = resolutionContext.getSessionFactory().getRuntimeMetamodels().getEntityMappingType(this.entityName);
                this.thisAsParentMemento = new HbmFetchParentMemento(new NavigablePath(entityDescriptor.getEntityName()), entityDescriptor);
            }
            return this.thisAsParentMemento;
        }
    }

    public static class HbmFetchParentMemento
    implements FetchMementoHbmStandard.FetchParentMemento {
        private final NavigablePath navigablePath;
        private final FetchableContainer fetchableContainer;

        public HbmFetchParentMemento(NavigablePath navigablePath, FetchableContainer fetchableContainer) {
            this.navigablePath = navigablePath;
            this.fetchableContainer = fetchableContainer;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public FetchableContainer getFetchableContainer() {
            return this.fetchableContainer;
        }
    }

    public static interface HbmFetchParent {
        public FetchMementoHbmStandard.FetchParentMemento resolveParentMemento(ResultSetMappingResolutionContext var1);
    }

    public static interface HbmFetchDescriptor
    extends FetchDescriptor {
        public String getFetchablePath();
    }
}

