/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class CacheSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public CacheSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean needsRowsToSkip() {
        return true;
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true);
        super.visitSqlSelections(selectClause);
    }

    @Override
    protected void renderTopClause(QuerySpec querySpec, boolean addOffset) {
        this.assertRowsOnlyFetchClauseType(querySpec);
        super.renderTopClause(querySpec, addOffset);
    }

    @Override
    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }
}

