/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.FetchClauseType;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2SqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public DB2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart) || this.getDialect().getVersion() < 1110 && (queryPart.isRoot() && this.hasLimit() || !(queryPart.getFetchClauseExpression() instanceof Literal)));
    }

    protected boolean supportsOffsetClause() {
        return this.getDialect().getVersion() >= 1110;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        boolean emulateFetchClause = this.shouldEmulateFetchClause(queryGroup);
        if (emulateFetchClause || this.hasOffset(queryGroup) && !this.supportsOffsetClause()) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, emulateFetchClause);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        boolean emulateFetchClause = this.shouldEmulateFetchClause(querySpec);
        if (emulateFetchClause || this.hasOffset(querySpec) && !this.supportsOffsetClause()) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, emulateFetchClause);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (!this.hasOffset(queryPart) || this.supportsOffsetClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else if (queryPart.isRoot() && this.hasLimit()) {
                this.renderFetch(this.getLimitParameter(), null, FetchClauseType.ROWS_ONLY);
            } else if (queryPart.getFetchClauseExpression() != null) {
                this.renderFetch(queryPart.getFetchClauseExpression(), null, queryPart.getFetchClauseType());
            }
        }
    }

    @Override
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitDeleteStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitUpdateStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitInsertStatementOnly(InsertStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitInsertStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    protected boolean renderReturningClause(MutationStatement statement) {
        List<ColumnReference> returningColumns = statement.getReturningColumns();
        int size = returningColumns.size();
        if (size == 0) {
            return false;
        }
        this.appendSql("select ");
        String separator = "";
        for (int i = 0; i < size; ++i) {
            this.appendSql(separator);
            this.appendSql(returningColumns.get(i).getColumnExpression());
            separator = ", ";
        }
        if (statement instanceof DeleteStatement) {
            this.appendSql(" from old table (");
        } else {
            this.appendSql(" from final table (");
        }
        return true;
    }

    @Override
    protected void visitReturningColumns(MutationStatement mutationStatement) {
    }
}

