/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2iSqlAstTranslator;
import org.hibernate.dialect.identity.DB2390IdentityColumnSupport;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2iSequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2iDialect
extends DB2Dialect {
    private final int version;

    public DB2iDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public DB2iDialect() {
        this(700);
    }

    public DB2iDialect(int version) {
        this.version = version;
    }

    public int getIVersion() {
        return this.version;
    }

    @Override
    protected UniqueDelegate createUniqueDelegate() {
        if (this.getIVersion() >= 730) {
            return new DefaultUniqueDelegate(this);
        }
        return super.createUniqueDelegate();
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        if (this.getIVersion() >= 730) {
            return DB2iSequenceSupport.INSTANCE;
        }
        return NoSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        if (this.getIVersion() >= 730) {
            return "select distinct sequence_name from qsys2.syssequences where ( current_schema = '*LIBL' and sequence_schema in ( select schema_name from qsys2.library_list_info ) ) or sequence_schema = current_schema";
        }
        return null;
    }

    @Override
    public String getForUpdateString() {
        return " for update with rs";
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.getIVersion() >= 730) {
            return FetchLimitHandler.INSTANCE;
        }
        return LegacyDB2LimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        if (this.getIVersion() >= 730) {
            return new DB2IdentityColumnSupport();
        }
        return new DB2390IdentityColumnSupport();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2iSqlAstTranslator(sessionFactory, statement, DB2iDialect.this.version);
            }
        };
    }
}

