/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class FirebirdSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public FirebirdSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().getVersion() >= 300 && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        Stack<Clause> clauseStack = this.getClauseStack();
        clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        if (!this.supportsOffsetFetchClause()) {
            this.renderFirstSkipClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() && !this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 300;
    }
}

