/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class InformixSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public InformixSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.supportsSkipFirstClause()) {
            this.renderSkipFirstClause((QuerySpec)this.getQueryPartStack().getCurrent());
        } else {
            this.renderFirstClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    protected boolean needsRowsToSkip() {
        return !this.supportsSkipFirstClause();
    }

    @Override
    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    @Override
    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion() >= 11;
    }

    private boolean supportsSkipFirstClause() {
        return this.getDialect().getVersion() >= 11;
    }
}

