/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.GroupByConstantRenderingStrategy;
import org.hibernate.dialect.IngresSqlAstTranslator;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Ingres10IdentityColumnSupport;
import org.hibernate.dialect.identity.Ingres9IdentityColumnSupport;
import org.hibernate.dialect.pagination.FirstLimitHandler;
import org.hibernate.dialect.pagination.IngresLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptorRegistry;

public class IngresDialect
extends Dialect {
    private final LimitHandler limitHandler;
    private final int version;
    private final SequenceSupport sequenceSupport;

    public IngresDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public IngresDialect() {
        this(920);
    }

    public IngresDialect(int version) {
        this.version = version;
        if (this.getVersion() < 1000) {
            this.registerColumnType(16, "tinyint");
        } else {
            this.registerColumnType(16, "boolean");
        }
        this.registerColumnType(2, "decimal($p, $s)");
        int maxStringLength = 32000;
        this.registerColumnType(-2, 32000L, "byte($l)");
        this.registerColumnType(-3, 32000L, "varbyte($l)");
        this.registerColumnType(-3, "long byte($l)");
        this.registerColumnType(1, 32000L, "char($l)");
        this.registerColumnType(12, 32000L, "varchar($l)");
        this.registerColumnType(12, "long varchar($l)");
        this.registerColumnType(-15, 32000L, "nchar($l)");
        this.registerColumnType(-9, 32000L, "nvarchar($l)");
        this.registerColumnType(-9, "long nvarchar($l)");
        if (this.getVersion() >= 930) {
            this.registerColumnType(91, "ansidate");
        }
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        if (this.getVersion() < 1000) {
            this.getDefaultProperties().setProperty("hibernate.query.substitutions", "true=1,false=0");
        }
        this.limitHandler = this.getVersion() < 930 ? FirstLimitHandler.INSTANCE : IngresLimitHandler.INSTANCE;
        this.sequenceSupport = new ANSISequenceSupport(){

            @Override
            public boolean supportsPooledSequences() {
                return IngresDialect.this.getVersion() >= 930;
            }
        };
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public SqlTypeDescriptor resolveSqlTypeDescriptor(int jdbcTypeCode, int precision, int scale, SqlTypeDescriptorRegistry sqlTypeDescriptorRegistry) {
        if (jdbcTypeCode == -7) {
            return sqlTypeDescriptorRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(jdbcTypeCode, precision, scale, sqlTypeDescriptorRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion() < 1000 ? -7 : 16;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return this.getVersion() < 1000 ? super.toBooleanValueString(bool) : String.valueOf(bool);
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 39;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.format_dateFormat(queryEngine);
        CommonFunctionFactory.dateTrunc(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "position(?1 in ?2)", "(position(?1 in substring(?2 from ?3)) + (?3) - 1)").setArgumentListSignature("(pattern, string[, start])");
        queryEngine.getSqmFunctionRegistry().registerPattern("extract", "date_part('?1', ?2)", StandardBasicTypes.INTEGER);
        CommonFunctionFactory.bitandorxornot_bitAndOrXorNot(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("squeeze").setExactArgumentCount(1).setInvariantType(StandardBasicTypes.STRING).register();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new IngresSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        return "timestampadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "timestampdiff(?1, ?2, ?3)";
    }

    @Override
    public boolean supportsTimezoneTypes() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid_to_char(uuid_create())";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getNullColumnString() {
        return " with null";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.sequenceSupport;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion() < 930 ? "select seq_name from iisequence" : "select seq_name from iisequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceNameExtractorImpl.INSTANCE;
    }

    @Override
    public String getLowercaseFunction() {
        return "lowercase";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        if (this.getVersion() >= 1000) {
            return new Ingres10IdentityColumnSupport();
        }
        if (this.getVersion() >= 930) {
            return new Ingres9IdentityColumnSupport();
        }
        return super.getIdentityColumnSupport();
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return this.getVersion() >= 930;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> "session." + name, this), () -> new TempIdTableExporter(false, this::getTypeName){

            @Override
            protected String getCreateOptions() {
                return "on commit preserve rows with norecovery";
            }

            @Override
            protected String getCreateCommand() {
                return "declare global temporary table";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return this.getVersion() >= 930 ? "current_timestamp" : "date(now)";
    }

    @Override
    public boolean supportsUnionAll() {
        return this.getVersion() >= 930;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return this.getVersion() >= 930;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return this.getVersion() >= 930;
    }

    @Override
    public String getFromDual() {
        return "from (select 0) as dual";
    }

    @Override
    public boolean supportsSelectQueryWithoutFromClause() {
        return false;
    }

    @Override
    public boolean supportsSubselectAsInPredicateLHS() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return MySQLDialect.datetimeFormat(format).result();
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public GroupByConstantRenderingStrategy getGroupByConstantRenderingStrategy() {
        return GroupByConstantRenderingStrategy.COLUMN_REFERENCE;
    }
}

