/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class OracleSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public OracleSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && !this.supportsOffsetFetchClause() && (queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    @Override
    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() || selectClause.isDistinct()) {
            super.renderRowNumber(selectClause, queryPart);
        } else {
            this.appendSql("rownum");
        }
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 12;
    }
}

