/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.FetchClauseType;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class PostgreSQLSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public PostgreSQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart || this.isRowsOnlyFetchClauseType(queryPart)) {
            return false;
        }
        FetchClauseType fetchClauseType = queryPart.getFetchClauseType();
        switch (fetchClauseType) {
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return !this.supportsOffsetFetchClausePercent();
            }
            case ROWS_WITH_TIES: {
                return !this.supportsOffsetFetchClauseWithTies();
            }
        }
        return false;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 840;
    }

    private boolean supportsOffsetFetchClauseWithTies() {
        return this.getDialect().getVersion() >= 1300;
    }

    private boolean supportsOffsetFetchClausePercent() {
        return false;
    }
}

