/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.spi.Exporter;

class SpannerDialectTableExporter
implements Exporter<Table> {
    private final SpannerDialect spannerDialect;
    private final String createTableTemplate;

    public SpannerDialectTableExporter(SpannerDialect spannerDialect) {
        this.spannerDialect = spannerDialect;
        this.createTableTemplate = this.spannerDialect.getCreateTableString() + " {0} ({1}) PRIMARY KEY ({2})";
    }

    @Override
    public String[] getSqlCreateStrings(Table table, Metadata metadata) {
        List<Column> keyColumns;
        if (table.hasPrimaryKey()) {
            keyColumns = table.getPrimaryKey().getColumns();
        } else if (table.getForeignKeys().size() > 0) {
            keyColumns = new ArrayList<Column>();
            Iterator<Column> column = table.getColumnIterator();
            while (column.hasNext()) {
                keyColumns.add(column.next());
            }
        } else {
            keyColumns = Collections.emptyList();
        }
        return this.getTableString(table, keyColumns);
    }

    private String[] getTableString(Table table, Iterable<Column> keyColumns) {
        String primaryKeyColNames = StreamSupport.stream(keyColumns.spliterator(), false).map(Column::getName).collect(Collectors.joining(","));
        StringJoiner colsAndTypes = new StringJoiner(",");
        Iterator<Column> column = table.getColumnIterator();
        while (column.hasNext()) {
            Column col = column.next();
            String columnDeclaration = col.getName() + " " + col.getSqlType() + (col.isNullable() ? this.spannerDialect.getNullColumnString() : " not null");
            colsAndTypes.add(columnDeclaration);
        }
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(MessageFormat.format(this.createTableTemplate, table.getQualifiedTableName().render(), colsAndTypes.toString(), primaryKeyColNames));
        if (table.getName().equals("hibernate_sequence")) {
            statements.add("INSERT INTO hibernate_sequence (next_val) VALUES(1)");
        }
        return statements.toArray(new String[0]);
    }

    @Override
    public String[] getSqlDropStrings(Table table, Metadata metadata) {
        ArrayList<String> dropStrings = new ArrayList<String>();
        Iterator<Index> index = table.getIndexIterator();
        while (index.hasNext()) {
            dropStrings.add("drop index " + index.next().getName());
        }
        dropStrings.add(this.spannerDialect.getDropTableString(table.getQualifiedTableName().render()));
        return dropStrings.toArray(new String[0]);
    }
}

