/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import javax.persistence.TemporalType;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.SybaseSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptorRegistry;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private final int version;
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;

    public SybaseDialect() {
        this(1100);
    }

    public SybaseDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public SybaseDialect(int version) {
        this.version = version;
        this.registerColumnType(-5, "numeric(19,0)");
    }

    @Override
    public SqlTypeDescriptor resolveSqlTypeDescriptor(int jdbcTypeCode, int precision, int scale, SqlTypeDescriptorRegistry sqlTypeDescriptorRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return sqlTypeDescriptorRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(jdbcTypeCode, precision, scale, sqlTypeDescriptorRegistry);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 2004: {
                return BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING;
            }
            case 2005: {
                return ClobTypeDescriptor.STREAM_BINDING_EXTRACTING;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.locate_charindex(queryEngine);
        CommonFunctionFactory.replace_strReplace(queryEngine);
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1, ?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1, ?2, ?3)";
    }
}

