/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.query.CastType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;

public class CastFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;
    private final CastType booleanCastType;

    public CastFunction(Dialect dialect, int preferredSqlTypeCodeForBoolean) {
        super("cast", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.useArgType(2));
        this.dialect = dialect;
        this.booleanCastType = this.getBooleanCastType(preferredSqlTypeCodeForBoolean);
    }

    private CastType getBooleanCastType(int preferredSqlTypeCodeForBoolean) {
        switch (preferredSqlTypeCodeForBoolean) {
            case -7: 
            case -6: 
            case 5: {
                return CastType.INTEGER_BOOLEAN;
            }
        }
        return CastType.BOOLEAN;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression source = (Expression)arguments.get(0);
        JdbcMapping sourceMapping = ((SqlExpressable)((Object)source.getExpressionType())).getJdbcMapping();
        CastType sourceType = this.getCastType(sourceMapping);
        CastTarget castTarget = (CastTarget)arguments.get(1);
        JdbcMapping targetJdbcMapping = castTarget.getExpressionType().getJdbcMapping();
        CastType targetType = this.getCastType(targetJdbcMapping);
        String cast = this.dialect.castPattern(sourceType, targetType);
        new PatternRenderer(cast).render(sqlAppender, arguments, walker);
    }

    private CastType getCastType(JdbcMapping sourceMapping) {
        CastType castType = sourceMapping.getCastType();
        if (castType == CastType.BOOLEAN) {
            return this.booleanCastType;
        }
        return castType;
    }

    @Override
    public String getArgumentListSignature() {
        return "(arg as Type)";
    }
}

